/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowRemovedMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;

public class FlowRemovedMessageFactoryTest {
    private OFDeserializer<FlowRemovedMessage> flowFactory;

    @Before
    public void startUp() {
        DeserializerRegistryImpl registry = new DeserializerRegistryImpl();
        registry.init();
        this.flowFactory = (OFDeserializer)registry.getDeserializer(new MessageCodeKey(4, 11, FlowRemovedMessage.class));
    }

    @Test
    public void test() {
        ByteBuf bb = BufferHelper.buildBuffer("00 01 02 03 04 05 06 07 00 03 02 04 00 00 00 02 00 00 00 05 00 01 00 03 00 01 02 03 04 05 06 07 00 01 02 03 04 05 06 07");
        FlowRemovedMessage builtByFactory = BufferHelper.deserialize(this.flowFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertTrue((builtByFactory.getCookie().longValue() == 283686952306183L ? 1 : 0) != 0);
        Assert.assertTrue((builtByFactory.getPriority() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Wrong reason", (long)2L, (long)builtByFactory.getReason().getIntValue());
        Assert.assertEquals((String)"Wrong tableId", (Object)new TableId(Long.valueOf(4L)), (Object)builtByFactory.getTableId());
        Assert.assertEquals((String)"Wrong durationSec", (long)2L, (long)builtByFactory.getDurationSec());
        Assert.assertEquals((String)"Wrong durationNsec", (long)5L, (long)builtByFactory.getDurationNsec());
        Assert.assertEquals((String)"Wrong idleTimeout", (long)1L, (long)builtByFactory.getIdleTimeout().intValue());
        Assert.assertEquals((String)"Wrong hardTimeout", (long)3L, (long)builtByFactory.getHardTimeout().intValue());
        Assert.assertEquals((String)"Wrong packetCount", (long)283686952306183L, (long)builtByFactory.getPacketCount().longValue());
        Assert.assertEquals((String)"Wrong byteCount", (long)283686952306183L, (long)builtByFactory.getByteCount().longValue());
    }
}

