/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowRemovedReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PacketInReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetAsyncOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.async.body.grouping.FlowRemovedMask;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.async.body.grouping.FlowRemovedMaskBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.async.body.grouping.PacketInMask;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.async.body.grouping.PacketInMaskBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.async.body.grouping.PortStatusMask;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.async.body.grouping.PortStatusMaskBuilder;

public class GetAsyncReplyMessageFactoryTest {
    private OFDeserializer<GetAsyncOutput> asyncFactory;

    @Before
    public void startUp() {
        DeserializerRegistryImpl registry = new DeserializerRegistryImpl();
        registry.init();
        this.asyncFactory = (OFDeserializer)registry.getDeserializer(new MessageCodeKey(4, 27, GetAsyncOutput.class));
    }

    @Test
    public void testGetAsyncReplyMessage() {
        ByteBuf bb = BufferHelper.buildBuffer("00 00 00 07 00 00 00 00 00 00 00 07 00 00 00 00 00 00 00 0F 00 00 00 00");
        GetAsyncOutput builtByFactory = BufferHelper.deserialize(this.asyncFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong packetInMask", GetAsyncReplyMessageFactoryTest.createPacketInMask(), (Object)builtByFactory.getPacketInMask());
        Assert.assertEquals((String)"Wrong portStatusMask", GetAsyncReplyMessageFactoryTest.createPortStatusMask(), (Object)builtByFactory.getPortStatusMask());
        Assert.assertEquals((String)"Wrong flowRemovedMask", GetAsyncReplyMessageFactoryTest.createFlowRemovedMask(), (Object)builtByFactory.getFlowRemovedMask());
    }

    private static List<PacketInMask> createPacketInMask() {
        ArrayList<PacketInMask> inMasks = new ArrayList<PacketInMask>();
        PacketInMaskBuilder maskBuilder = new PacketInMaskBuilder();
        ArrayList<PacketInReason> reasons = new ArrayList<PacketInReason>();
        reasons.add(PacketInReason.OFPRNOMATCH);
        reasons.add(PacketInReason.OFPRACTION);
        reasons.add(PacketInReason.OFPRINVALIDTTL);
        maskBuilder.setMask(reasons);
        inMasks.add(maskBuilder.build());
        maskBuilder = new PacketInMaskBuilder();
        reasons = new ArrayList();
        maskBuilder.setMask(reasons);
        inMasks.add(maskBuilder.build());
        return inMasks;
    }

    private static List<PortStatusMask> createPortStatusMask() {
        ArrayList<PortStatusMask> inMasks = new ArrayList<PortStatusMask>();
        PortStatusMaskBuilder maskBuilder = new PortStatusMaskBuilder();
        ArrayList<PortReason> reasons = new ArrayList<PortReason>();
        reasons.add(PortReason.OFPPRADD);
        reasons.add(PortReason.OFPPRDELETE);
        reasons.add(PortReason.OFPPRMODIFY);
        inMasks.add(maskBuilder.setMask(reasons).build());
        maskBuilder = new PortStatusMaskBuilder();
        reasons = new ArrayList();
        maskBuilder.setMask(reasons);
        inMasks.add(maskBuilder.build());
        return inMasks;
    }

    private static List<FlowRemovedMask> createFlowRemovedMask() {
        ArrayList<FlowRemovedMask> inMasks = new ArrayList<FlowRemovedMask>();
        FlowRemovedMaskBuilder maskBuilder = new FlowRemovedMaskBuilder();
        ArrayList<FlowRemovedReason> reasons = new ArrayList<FlowRemovedReason>();
        reasons.add(FlowRemovedReason.OFPRRIDLETIMEOUT);
        reasons.add(FlowRemovedReason.OFPRRHARDTIMEOUT);
        reasons.add(FlowRemovedReason.OFPRRDELETE);
        reasons.add(FlowRemovedReason.OFPRRGROUPDELETE);
        maskBuilder.setMask(reasons);
        inMasks.add(maskBuilder.build());
        maskBuilder = new FlowRemovedMaskBuilder();
        reasons = new ArrayList();
        maskBuilder.setMask(reasons);
        inMasks.add(maskBuilder.build());
        return inMasks;
    }
}

