/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupModCommand;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GroupModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.buckets.grouping.BucketsList;

public class GroupModInputMessageFactoryTest {
    private OFDeserializer<GroupModInput> factory;

    @Before
    public void startUp() {
        DeserializerRegistryImpl desRegistry = new DeserializerRegistryImpl();
        desRegistry.init();
        this.factory = (OFDeserializer)desRegistry.getDeserializer(new MessageCodeKey(4, 15, GroupModInput.class));
    }

    @Test
    public void test() {
        ByteBuf bb = BufferHelper.buildBuffer("00 02 03 00 00 00 01 00 00 10 00 0a 00 00 00 41 00 00 00 16 00 00 00 00");
        GroupModInput deserializedMessage = BufferHelper.deserialize(this.factory, bb);
        BufferHelper.checkHeaderV13((OfHeader)deserializedMessage);
        Assert.assertEquals((String)"Wrong command", (Object)GroupModCommand.forValue((int)2), (Object)deserializedMessage.getCommand());
        Assert.assertEquals((String)"Wrong type", (Object)GroupType.forValue((int)3), (Object)deserializedMessage.getType());
        Assert.assertEquals((String)"Wrong group id", (Object)new GroupId(Long.valueOf(256L)), (Object)deserializedMessage.getGroupId());
        BucketsList bucket = (BucketsList)deserializedMessage.getBucketsList().get(0);
        Assert.assertEquals((String)"Wrong weight", (long)10L, (long)bucket.getWeight().intValue());
        Assert.assertEquals((String)"Wrong watch port", (Object)new PortNumber(Long.valueOf(65L)), (Object)bucket.getWatchPort());
        Assert.assertEquals((String)"Wrong watch group", (long)22L, (long)bucket.getWatchGroup());
    }
}

