/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.HelloElementType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.HelloMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.hello.Elements;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.hello.ElementsBuilder;

public class HelloMessageFactoryTest {
    private OFDeserializer<HelloMessage> helloFactory;

    @Before
    public void startUp() {
        DeserializerRegistryImpl registry = new DeserializerRegistryImpl();
        registry.init();
        this.helloFactory = (OFDeserializer)registry.getDeserializer(new MessageCodeKey(4, 0, HelloMessage.class));
    }

    @Test
    public void testWithoutPadding() {
        ByteBuf bb = BufferHelper.buildBuffer("00 01 00 08 00 00 00 11");
        HelloMessage builtByFactory = BufferHelper.deserialize(this.helloFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        List<Elements> element = HelloMessageFactoryTest.createElement(4, HelloElementType.VERSIONBITMAP.getIntValue());
        Assert.assertEquals((String)"Wrong type", (Object)element.get(0).getType(), (Object)((Elements)builtByFactory.getElements().get(0)).getType());
        Assert.assertEquals((String)"Wrong versionBitmap", (Object)element.get(0).getVersionBitmap(), (Object)((Elements)builtByFactory.getElements().get(0)).getVersionBitmap());
    }

    @Test
    public void testWithPadding() {
        ByteBuf bb = BufferHelper.buildBuffer("00 01 00 0c 00 00 00 11 00 00 00 00 00 00 00 00");
        HelloMessage builtByFactory = BufferHelper.deserialize(this.helloFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        List<Elements> element = HelloMessageFactoryTest.createElement(8, HelloElementType.VERSIONBITMAP.getIntValue());
        Assert.assertEquals((String)"Wrong type", (Object)element.get(0).getType(), (Object)((Elements)builtByFactory.getElements().get(0)).getType());
        Assert.assertEquals((String)"Wrong versionBitmap", (Object)element.get(0).getVersionBitmap(), (Object)((Elements)builtByFactory.getElements().get(0)).getVersionBitmap());
    }

    @Test
    public void testBadType() {
        ByteBuf bb = BufferHelper.buildBuffer("00 02 00 0c 00 00 00 11 00 00 00 00 00 00 00 00");
        HelloMessage builtByFactory = BufferHelper.deserialize(this.helloFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong - no element has been expected", (long)0L, (long)builtByFactory.getElements().size());
    }

    private static List<Elements> createElement(int lengthInByte, int type) {
        ElementsBuilder elementsBuilder = new ElementsBuilder();
        ArrayList<Elements> elementsList = new ArrayList<Elements>();
        ArrayList<Boolean> booleanList = new ArrayList<Boolean>();
        booleanList.add(true);
        booleanList.add(false);
        booleanList.add(false);
        booleanList.add(false);
        booleanList.add(true);
        int inSize = booleanList.size();
        for (int i = 1; i < lengthInByte * 8 - inSize + 1; ++i) {
            booleanList.add(false);
        }
        elementsBuilder.setType(HelloElementType.forValue((int)type));
        elementsBuilder.setVersionBitmap(booleanList);
        elementsList.add(elementsBuilder.build());
        return elementsList;
    }
}

