/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import java.math.BigInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.CopyTtlInCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.CopyTtlOutCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.DecMplsTtlCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.DecNwTtlCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.GroupCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.OutputActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.PopMplsCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.PopPbbCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.PopVlanCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.PushMplsCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.PushPbbCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.PushVlanCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetFieldCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetMplsTtlCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetNwTtlCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetQueueCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.InPort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OpenflowBasicClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.InPortCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartReplyMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.buckets.grouping.BucketsList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.MeterBandDropCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.MeterBandDscpRemarkCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.meter.band.drop._case.MeterBandDrop;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.meter.band.dscp.remark._case.MeterBandDscpRemark;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyAggregateCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyDescCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyGroupCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyGroupDescCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyMeterCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyMeterConfigCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyPortStatsCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyQueueCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyTableCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.aggregate._case.MultipartReplyAggregate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.desc._case.MultipartReplyDesc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group._case.MultipartReplyGroup;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group._case.multipart.reply.group.GroupStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group._case.multipart.reply.group.group.stats.BucketStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group.desc._case.MultipartReplyGroupDesc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group.desc._case.multipart.reply.group.desc.GroupDesc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter._case.MultipartReplyMeter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter._case.multipart.reply.meter.MeterStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter._case.multipart.reply.meter.meter.stats.MeterBandStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.config._case.MultipartReplyMeterConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.config._case.multipart.reply.meter.config.MeterConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.config._case.multipart.reply.meter.config.meter.config.Bands;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.stats._case.MultipartReplyPortStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.stats._case.multipart.reply.port.stats.PortStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.queue._case.MultipartReplyQueue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.queue._case.multipart.reply.queue.QueueStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table._case.MultipartReplyTable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table._case.multipart.reply.table.TableStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipartReplyMessageFactoryTest {
    private OFDeserializer<MultipartReplyMessage> multipartFactory;
    private static final Logger LOG = LoggerFactory.getLogger(MultipartReplyMessageFactoryTest.class);

    @Before
    public void startUp() {
        DeserializerRegistryImpl registry = new DeserializerRegistryImpl();
        registry.init();
        this.multipartFactory = (OFDeserializer)registry.getDeserializer(new MessageCodeKey(4, 19, MultipartReplyMessage.class));
    }

    @Test
    public void testMultipartReplyDescBody() {
        int DESC_STR_LEN = 256;
        int SERIAL_NUM_LEN = 32;
        ByteBuf bb = BufferHelper.buildBuffer("00 00 00 01 00 00 00 00");
        String mfrDesc = "Manufacturer description";
        byte[] mfrDescBytes = new byte[256];
        mfrDescBytes = mfrDesc.getBytes();
        bb.writeBytes(mfrDescBytes);
        bb.writeZero(256 - mfrDescBytes.length);
        String hwDesc = "Hardware description";
        byte[] hwDescBytes = new byte[256];
        hwDescBytes = hwDesc.getBytes();
        bb.writeBytes(hwDescBytes);
        bb.writeZero(256 - hwDescBytes.length);
        String swDesc = "Software description";
        byte[] swDescBytes = new byte[256];
        swDescBytes = swDesc.getBytes();
        bb.writeBytes(swDescBytes);
        bb.writeZero(256 - swDescBytes.length);
        String serialNum = "SN0123456789";
        byte[] serialNumBytes = new byte[32];
        serialNumBytes = serialNum.getBytes();
        bb.writeBytes(serialNumBytes);
        bb.writeZero(32 - serialNumBytes.length);
        String dpDesc = "switch3 in room 3120";
        byte[] dpDescBytes = new byte[256];
        dpDescBytes = dpDesc.getBytes();
        bb.writeBytes(dpDescBytes);
        bb.writeZero(256 - dpDescBytes.length);
        MultipartReplyMessage builtByFactory = BufferHelper.deserialize(this.multipartFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)0L, (long)builtByFactory.getType().getIntValue());
        Assert.assertEquals((String)"Wrong flag", (Object)true, (Object)builtByFactory.getFlags().isOFPMPFREQMORE());
        MultipartReplyDescCase messageCase = (MultipartReplyDescCase)builtByFactory.getMultipartReplyBody();
        MultipartReplyDesc message = messageCase.getMultipartReplyDesc();
        Assert.assertEquals((String)"Wrong mfrDesc", (Object)"Manufacturer description", (Object)message.getMfrDesc());
        Assert.assertEquals((String)"Wrong hwDesc", (Object)"Hardware description", (Object)message.getHwDesc());
        Assert.assertEquals((String)"Wrong swDesc", (Object)"Software description", (Object)message.getSwDesc());
        Assert.assertEquals((String)"Wrong serialNum", (Object)"SN0123456789", (Object)message.getSerialNum());
        Assert.assertEquals((String)"Wrong dpDesc", (Object)"switch3 in room 3120", (Object)message.getDpDesc());
    }

    @Test
    public void testMultipartReplyAggregateBody() {
        ByteBuf bb = BufferHelper.buildBuffer("00 02 00 01 00 00 00 00 FF 01 01 01 01 01 01 01 0F 01 01 01 01 01 01 01 00 00 00 08 00 00 00 00");
        MultipartReplyMessage builtByFactory = BufferHelper.deserialize(this.multipartFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)2L, (long)builtByFactory.getType().getIntValue());
        Assert.assertEquals((String)"Wrong flag", (Object)true, (Object)builtByFactory.getFlags().isOFPMPFREQMORE());
        MultipartReplyAggregateCase messageCase = (MultipartReplyAggregateCase)builtByFactory.getMultipartReplyBody();
        MultipartReplyAggregate message = messageCase.getMultipartReplyAggregate();
        Assert.assertEquals((String)"Wrong packetCount", (Object)new BigInteger(1, new byte[]{-1, 1, 1, 1, 1, 1, 1, 1}), (Object)message.getPacketCount());
        Assert.assertEquals((String)"Wrong byteCount", (Object)new BigInteger(1, new byte[]{15, 1, 1, 1, 1, 1, 1, 1}), (Object)message.getByteCount());
        Assert.assertEquals((String)"Wrong flowCount", (long)8L, (long)message.getFlowCount().intValue());
    }

    @Test
    public void testMultipartReplyTableBody() {
        ByteBuf bb = BufferHelper.buildBuffer("00 03 00 01 00 00 00 00 08 00 00 00 00 00 00 10 FF 01 01 01 01 01 01 01 AF 01 01 01 01 01 01 01");
        MultipartReplyMessage builtByFactory = BufferHelper.deserialize(this.multipartFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)3L, (long)builtByFactory.getType().getIntValue());
        Assert.assertEquals((String)"Wrong flag", (Object)true, (Object)builtByFactory.getFlags().isOFPMPFREQMORE());
        MultipartReplyTableCase messageCase = (MultipartReplyTableCase)builtByFactory.getMultipartReplyBody();
        MultipartReplyTable message = messageCase.getMultipartReplyTable();
        Assert.assertEquals((String)"Wrong tableId", (long)8L, (long)((TableStats)message.getTableStats().get(0)).getTableId().intValue());
        Assert.assertEquals((String)"Wrong activeCount", (long)16L, (long)((TableStats)message.getTableStats().get(0)).getActiveCount());
        Assert.assertEquals((String)"Wrong lookupCount", (Object)new BigInteger(1, new byte[]{-1, 1, 1, 1, 1, 1, 1, 1}), (Object)((TableStats)message.getTableStats().get(0)).getLookupCount());
        Assert.assertEquals((String)"Wrong matchedCount", (Object)new BigInteger(1, new byte[]{-81, 1, 1, 1, 1, 1, 1, 1}), (Object)((TableStats)message.getTableStats().get(0)).getMatchedCount());
    }

    @Test
    public void testMultipartReplyPortStatsBody() {
        ByteBuf bb = BufferHelper.buildBuffer("00 04 00 01 00 00 00 00 00 00 00 FF 00 00 00 00 FF 01 01 01 01 01 01 01 FF 02 02 02 02 02 02 02 FF 02 03 02 03 02 03 02 FF 02 03 02 03 02 03 02 FF 02 03 02 03 02 03 02 FF 02 03 02 03 02 03 02 FF 02 03 02 03 02 03 02 FF 02 03 02 03 02 03 02 FF 02 03 02 03 02 03 02 FF 02 03 02 03 02 03 02 FF 02 03 02 03 02 03 02 FF 02 03 02 03 02 03 02 00 00 00 02 00 00 00 04");
        MultipartReplyMessage builtByFactory = BufferHelper.deserialize(this.multipartFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)4L, (long)builtByFactory.getType().getIntValue());
        Assert.assertEquals((String)"Wrong flag", (Object)true, (Object)builtByFactory.getFlags().isOFPMPFREQMORE());
        MultipartReplyPortStatsCase messageCase = (MultipartReplyPortStatsCase)builtByFactory.getMultipartReplyBody();
        MultipartReplyPortStats message = messageCase.getMultipartReplyPortStats();
        Assert.assertEquals((String)"Wrong portNo", (long)255L, (long)((PortStats)message.getPortStats().get(0)).getPortNo().intValue());
        Assert.assertEquals((String)"Wrong rxPackets", (Object)new BigInteger(1, new byte[]{-1, 1, 1, 1, 1, 1, 1, 1}), (Object)((PortStats)message.getPortStats().get(0)).getRxPackets());
        Assert.assertEquals((String)"Wrong txPackets", (Object)new BigInteger(1, new byte[]{-1, 2, 2, 2, 2, 2, 2, 2}), (Object)((PortStats)message.getPortStats().get(0)).getTxPackets());
        Assert.assertEquals((String)"Wrong rxBytes", (Object)new BigInteger(1, new byte[]{-1, 2, 3, 2, 3, 2, 3, 2}), (Object)((PortStats)message.getPortStats().get(0)).getRxBytes());
        Assert.assertEquals((String)"Wrong txBytes", (Object)new BigInteger(1, new byte[]{-1, 2, 3, 2, 3, 2, 3, 2}), (Object)((PortStats)message.getPortStats().get(0)).getTxBytes());
        Assert.assertEquals((String)"Wrong rxDropped", (Object)new BigInteger(1, new byte[]{-1, 2, 3, 2, 3, 2, 3, 2}), (Object)((PortStats)message.getPortStats().get(0)).getRxDropped());
        Assert.assertEquals((String)"Wrong txDropped", (Object)new BigInteger(1, new byte[]{-1, 2, 3, 2, 3, 2, 3, 2}), (Object)((PortStats)message.getPortStats().get(0)).getTxDropped());
        Assert.assertEquals((String)"Wrong rxErrors", (Object)new BigInteger(1, new byte[]{-1, 2, 3, 2, 3, 2, 3, 2}), (Object)((PortStats)message.getPortStats().get(0)).getRxErrors());
        Assert.assertEquals((String)"Wrong txErrors", (Object)new BigInteger(1, new byte[]{-1, 2, 3, 2, 3, 2, 3, 2}), (Object)((PortStats)message.getPortStats().get(0)).getTxErrors());
        Assert.assertEquals((String)"Wrong rxFrameErr", (Object)new BigInteger(1, new byte[]{-1, 2, 3, 2, 3, 2, 3, 2}), (Object)((PortStats)message.getPortStats().get(0)).getRxFrameErr());
        Assert.assertEquals((String)"Wrong rxOverErr", (Object)new BigInteger(1, new byte[]{-1, 2, 3, 2, 3, 2, 3, 2}), (Object)((PortStats)message.getPortStats().get(0)).getRxOverErr());
        Assert.assertEquals((String)"Wrong rxCrcErr", (Object)new BigInteger(1, new byte[]{-1, 2, 3, 2, 3, 2, 3, 2}), (Object)((PortStats)message.getPortStats().get(0)).getRxCrcErr());
        Assert.assertEquals((String)"Wrong collisions", (Object)new BigInteger(1, new byte[]{-1, 2, 3, 2, 3, 2, 3, 2}), (Object)((PortStats)message.getPortStats().get(0)).getCollisions());
        Assert.assertEquals((String)"Wrong durationSec", (long)2L, (long)((PortStats)message.getPortStats().get(0)).getDurationSec().intValue());
        Assert.assertEquals((String)"Wrong durationNsec", (long)4L, (long)((PortStats)message.getPortStats().get(0)).getDurationNsec().intValue());
    }

    @Test
    public void testMultipartReplyQueueBody() {
        ByteBuf bb = BufferHelper.buildBuffer("00 05 00 01 00 00 00 00 00 00 00 FF 00 00 00 10 FF 02 03 02 03 02 03 02 FF 02 02 02 02 02 02 02 FF 02 03 02 03 02 03 02 00 00 00 02 00 00 00 04");
        MultipartReplyMessage builtByFactory = BufferHelper.deserialize(this.multipartFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)5L, (long)builtByFactory.getType().getIntValue());
        Assert.assertEquals((String)"Wrong flag", (Object)true, (Object)builtByFactory.getFlags().isOFPMPFREQMORE());
        MultipartReplyQueueCase messageCase = (MultipartReplyQueueCase)builtByFactory.getMultipartReplyBody();
        MultipartReplyQueue message = messageCase.getMultipartReplyQueue();
        Assert.assertEquals((String)"Wrong portNo", (long)255L, (long)((QueueStats)message.getQueueStats().get(0)).getPortNo().intValue());
        Assert.assertEquals((String)"Wrong queueId", (long)16L, (long)((QueueStats)message.getQueueStats().get(0)).getQueueId().intValue());
        Assert.assertEquals((String)"Wrong txBytes", (Object)new BigInteger(1, new byte[]{-1, 2, 3, 2, 3, 2, 3, 2}), (Object)((QueueStats)message.getQueueStats().get(0)).getTxBytes());
        Assert.assertEquals((String)"Wrong txPackets", (Object)new BigInteger(1, new byte[]{-1, 2, 2, 2, 2, 2, 2, 2}), (Object)((QueueStats)message.getQueueStats().get(0)).getTxPackets());
        Assert.assertEquals((String)"Wrong txErrors", (Object)new BigInteger(1, new byte[]{-1, 2, 3, 2, 3, 2, 3, 2}), (Object)((QueueStats)message.getQueueStats().get(0)).getTxErrors());
        Assert.assertEquals((String)"Wrong durationSec", (long)2L, (long)((QueueStats)message.getQueueStats().get(0)).getDurationSec().intValue());
        Assert.assertEquals((String)"Wrong durationNsec", (long)4L, (long)((QueueStats)message.getQueueStats().get(0)).getDurationNsec().intValue());
    }

    @Test
    public void testMultipartReplyGroupBody() {
        ByteBuf bb = BufferHelper.buildBuffer("00 06 00 01 00 00 00 00 00 48 00 00 00 00 00 10 00 00 00 12 00 00 00 00 FF 01 01 01 01 01 01 01 FF 01 01 01 01 01 01 01 00 00 00 08 00 00 00 09 FF 01 01 01 01 01 01 01 FF 01 01 01 01 01 01 01 FF 02 02 02 02 02 02 02 FF 02 02 02 02 02 02 02 00 48 00 00 00 00 00 10 00 00 00 12 00 00 00 00 FF 01 01 01 01 01 01 01 FF 01 01 01 01 01 01 01 00 00 00 08 00 00 00 09 FF 01 01 01 01 01 01 01 FF 01 01 01 01 01 01 01 FF 02 02 02 02 02 02 02 FF 02 02 02 02 02 02 02");
        MultipartReplyMessage builtByFactory = BufferHelper.deserialize(this.multipartFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)6L, (long)builtByFactory.getType().getIntValue());
        Assert.assertEquals((String)"Wrong flag", (Object)true, (Object)builtByFactory.getFlags().isOFPMPFREQMORE());
        MultipartReplyGroupCase messageCase = (MultipartReplyGroupCase)builtByFactory.getMultipartReplyBody();
        MultipartReplyGroup message = messageCase.getMultipartReplyGroup();
        Assert.assertEquals((String)"Wrong groupId", (long)16L, (long)((GroupStats)message.getGroupStats().get(0)).getGroupId().getValue().intValue());
        Assert.assertEquals((String)"Wrong refCount", (long)18L, (long)((GroupStats)message.getGroupStats().get(0)).getRefCount().intValue());
        Assert.assertEquals((String)"Wrong packetCount", (Object)new BigInteger(1, new byte[]{-1, 1, 1, 1, 1, 1, 1, 1}), (Object)((GroupStats)message.getGroupStats().get(0)).getPacketCount());
        Assert.assertEquals((String)"Wrong byteCount", (Object)new BigInteger(1, new byte[]{-1, 1, 1, 1, 1, 1, 1, 1}), (Object)((GroupStats)message.getGroupStats().get(0)).getByteCount());
        Assert.assertEquals((String)"Wrong durationSec", (long)8L, (long)((GroupStats)message.getGroupStats().get(0)).getDurationSec().intValue());
        Assert.assertEquals((String)"Wrong durationNsec", (long)9L, (long)((GroupStats)message.getGroupStats().get(0)).getDurationNsec().intValue());
        Assert.assertEquals((String)"Wrong packetCountBucket", (Object)new BigInteger(1, new byte[]{-1, 1, 1, 1, 1, 1, 1, 1}), (Object)((BucketStats)((GroupStats)message.getGroupStats().get(0)).getBucketStats().get(0)).getPacketCount());
        Assert.assertEquals((String)"Wrong byteCountBucket", (Object)new BigInteger(1, new byte[]{-1, 1, 1, 1, 1, 1, 1, 1}), (Object)((BucketStats)((GroupStats)message.getGroupStats().get(0)).getBucketStats().get(0)).getByteCount());
        Assert.assertEquals((String)"Wrong packetCountBucket_2", (Object)new BigInteger(1, new byte[]{-1, 2, 2, 2, 2, 2, 2, 2}), (Object)((BucketStats)((GroupStats)message.getGroupStats().get(0)).getBucketStats().get(1)).getPacketCount());
        Assert.assertEquals((String)"Wrong byteCountBucket_2", (Object)new BigInteger(1, new byte[]{-1, 2, 2, 2, 2, 2, 2, 2}), (Object)((BucketStats)((GroupStats)message.getGroupStats().get(0)).getBucketStats().get(1)).getByteCount());
        Assert.assertEquals((String)"Wrong groupId_2", (long)16L, (long)((GroupStats)message.getGroupStats().get(1)).getGroupId().getValue().intValue());
        Assert.assertEquals((String)"Wrong refCount_2", (long)18L, (long)((GroupStats)message.getGroupStats().get(1)).getRefCount().intValue());
        Assert.assertEquals((String)"Wrong packetCount_2", (Object)new BigInteger(1, new byte[]{-1, 1, 1, 1, 1, 1, 1, 1}), (Object)((GroupStats)message.getGroupStats().get(1)).getPacketCount());
        Assert.assertEquals((String)"Wrong byteCount_2", (Object)new BigInteger(1, new byte[]{-1, 1, 1, 1, 1, 1, 1, 1}), (Object)((GroupStats)message.getGroupStats().get(1)).getByteCount());
        Assert.assertEquals((String)"Wrong durationSec_2", (long)8L, (long)((GroupStats)message.getGroupStats().get(1)).getDurationSec().intValue());
        Assert.assertEquals((String)"Wrong durationNsec_2", (long)9L, (long)((GroupStats)message.getGroupStats().get(1)).getDurationNsec().intValue());
        Assert.assertEquals((String)"Wrong packetCountBucket_1.2", (Object)new BigInteger(1, new byte[]{-1, 1, 1, 1, 1, 1, 1, 1}), (Object)((BucketStats)((GroupStats)message.getGroupStats().get(1)).getBucketStats().get(0)).getPacketCount());
        Assert.assertEquals((String)"Wrong byteCountBucket_1.2", (Object)new BigInteger(1, new byte[]{-1, 1, 1, 1, 1, 1, 1, 1}), (Object)((BucketStats)((GroupStats)message.getGroupStats().get(1)).getBucketStats().get(0)).getByteCount());
        Assert.assertEquals((String)"Wrong packetCountBucket_2.2", (Object)new BigInteger(1, new byte[]{-1, 2, 2, 2, 2, 2, 2, 2}), (Object)((BucketStats)((GroupStats)message.getGroupStats().get(1)).getBucketStats().get(1)).getPacketCount());
        Assert.assertEquals((String)"Wrong byteCountBucket_2.2", (Object)new BigInteger(1, new byte[]{-1, 2, 2, 2, 2, 2, 2, 2}), (Object)((BucketStats)((GroupStats)message.getGroupStats().get(1)).getBucketStats().get(1)).getByteCount());
    }

    @Test
    public void testMultipartReplyMeterBody() {
        ByteBuf bb = BufferHelper.buildBuffer("00 09 00 01 00 00 00 00 00 00 00 09 00 58 00 00 00 00 00 00 00 00 00 07 FF 01 01 01 01 01 01 01 FF 01 01 01 01 01 01 01 00 00 00 05 00 00 00 05 FF 01 01 01 01 01 01 01 FF 01 01 01 01 01 01 01 FF 02 02 02 02 02 02 02 FF 02 02 02 02 02 02 02 FF 03 03 03 03 03 03 03 FF 03 03 03 03 03 03 03");
        MultipartReplyMessage builtByFactory = BufferHelper.deserialize(this.multipartFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)9L, (long)builtByFactory.getType().getIntValue());
        Assert.assertEquals((String)"Wrong flag", (Object)true, (Object)builtByFactory.getFlags().isOFPMPFREQMORE());
        MultipartReplyMeterCase messageCase = (MultipartReplyMeterCase)builtByFactory.getMultipartReplyBody();
        MultipartReplyMeter message = messageCase.getMultipartReplyMeter();
        Assert.assertEquals((String)"Wrong meterId", (long)9L, (long)((MeterStats)message.getMeterStats().get(0)).getMeterId().getValue().intValue());
        Assert.assertEquals((String)"Wrong flowCount", (long)7L, (long)((MeterStats)message.getMeterStats().get(0)).getFlowCount().intValue());
        Assert.assertEquals((String)"Wrong packetInCount", (Object)new BigInteger(1, new byte[]{-1, 1, 1, 1, 1, 1, 1, 1}), (Object)((MeterStats)message.getMeterStats().get(0)).getPacketInCount());
        Assert.assertEquals((String)"Wrong byteInCount", (Object)new BigInteger(1, new byte[]{-1, 1, 1, 1, 1, 1, 1, 1}), (Object)((MeterStats)message.getMeterStats().get(0)).getByteInCount());
        Assert.assertEquals((String)"Wrong durationSec", (long)5L, (long)((MeterStats)message.getMeterStats().get(0)).getDurationSec().intValue());
        Assert.assertEquals((String)"Wrong durationNsec", (long)5L, (long)((MeterStats)message.getMeterStats().get(0)).getDurationNsec().intValue());
        Assert.assertEquals((String)"Wrong packetBandCount_01", (Object)new BigInteger(1, new byte[]{-1, 1, 1, 1, 1, 1, 1, 1}), (Object)((MeterBandStats)((MeterStats)message.getMeterStats().get(0)).getMeterBandStats().get(0)).getPacketBandCount());
        Assert.assertEquals((String)"Wrong byteBandCount_01", (Object)new BigInteger(1, new byte[]{-1, 1, 1, 1, 1, 1, 1, 1}), (Object)((MeterBandStats)((MeterStats)message.getMeterStats().get(0)).getMeterBandStats().get(0)).getByteBandCount());
        Assert.assertEquals((String)"Wrong packetBandCount_02", (Object)new BigInteger(1, new byte[]{-1, 2, 2, 2, 2, 2, 2, 2}), (Object)((MeterBandStats)((MeterStats)message.getMeterStats().get(0)).getMeterBandStats().get(1)).getPacketBandCount());
        Assert.assertEquals((String)"Wrong byteBandCount_02", (Object)new BigInteger(1, new byte[]{-1, 2, 2, 2, 2, 2, 2, 2}), (Object)((MeterBandStats)((MeterStats)message.getMeterStats().get(0)).getMeterBandStats().get(1)).getByteBandCount());
        Assert.assertEquals((String)"Wrong packetBandCount_03", (Object)new BigInteger(1, new byte[]{-1, 3, 3, 3, 3, 3, 3, 3}), (Object)((MeterBandStats)((MeterStats)message.getMeterStats().get(0)).getMeterBandStats().get(2)).getPacketBandCount());
        Assert.assertEquals((String)"Wrong byteBandCount_03", (Object)new BigInteger(1, new byte[]{-1, 3, 3, 3, 3, 3, 3, 3}), (Object)((MeterBandStats)((MeterStats)message.getMeterStats().get(0)).getMeterBandStats().get(2)).getByteBandCount());
    }

    @Test
    public void testMultipartReplyMeterBodyMulti() {
        ByteBuf bb = BufferHelper.buildBuffer("00 09 00 01 00 00 00 00 00 00 00 09 00 58 00 00 00 00 00 00 00 00 00 07 FF 01 01 01 01 01 01 01 FF 01 01 01 01 01 01 01 00 00 00 05 00 00 00 05 FF 01 01 01 01 01 01 01 FF 01 01 01 01 01 01 01 FF 02 02 02 02 02 02 02 FF 02 02 02 02 02 02 02 FF 03 03 03 03 03 03 03 FF 03 03 03 03 03 03 03 00 00 00 08 00 58 00 00 00 00 00 00 00 00 00 07 FF 01 01 01 01 01 01 01 FF 01 01 01 01 01 01 01 00 00 00 05 00 00 00 05 FF 01 01 01 01 01 01 01 FF 01 01 01 01 01 01 01 FF 02 02 02 02 02 02 02 FF 02 02 02 02 02 02 02 FF 03 03 03 03 03 03 03 FF 03 03 03 03 03 03 03");
        MultipartReplyMessage builtByFactory = BufferHelper.deserialize(this.multipartFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)9L, (long)builtByFactory.getType().getIntValue());
        Assert.assertEquals((String)"Wrong flag", (Object)true, (Object)builtByFactory.getFlags().isOFPMPFREQMORE());
        MultipartReplyMeterCase messageCase = (MultipartReplyMeterCase)builtByFactory.getMultipartReplyBody();
        MultipartReplyMeter message = messageCase.getMultipartReplyMeter();
        Assert.assertEquals((String)"Wrong meterId", (long)9L, (long)((MeterStats)message.getMeterStats().get(0)).getMeterId().getValue().intValue());
        Assert.assertEquals((String)"Wrong flowCount", (long)7L, (long)((MeterStats)message.getMeterStats().get(0)).getFlowCount().intValue());
        Assert.assertEquals((String)"Wrong packetInCount", (Object)new BigInteger(1, new byte[]{-1, 1, 1, 1, 1, 1, 1, 1}), (Object)((MeterStats)message.getMeterStats().get(0)).getPacketInCount());
        Assert.assertEquals((String)"Wrong byteInCount", (Object)new BigInteger(1, new byte[]{-1, 1, 1, 1, 1, 1, 1, 1}), (Object)((MeterStats)message.getMeterStats().get(0)).getByteInCount());
        Assert.assertEquals((String)"Wrong durationSec", (long)5L, (long)((MeterStats)message.getMeterStats().get(0)).getDurationSec().intValue());
        Assert.assertEquals((String)"Wrong durationNsec", (long)5L, (long)((MeterStats)message.getMeterStats().get(0)).getDurationNsec().intValue());
        Assert.assertEquals((String)"Wrong packetBandCount_01", (Object)new BigInteger(1, new byte[]{-1, 1, 1, 1, 1, 1, 1, 1}), (Object)((MeterBandStats)((MeterStats)message.getMeterStats().get(0)).getMeterBandStats().get(0)).getPacketBandCount());
        Assert.assertEquals((String)"Wrong byteBandCount_01", (Object)new BigInteger(1, new byte[]{-1, 1, 1, 1, 1, 1, 1, 1}), (Object)((MeterBandStats)((MeterStats)message.getMeterStats().get(0)).getMeterBandStats().get(0)).getByteBandCount());
        Assert.assertEquals((String)"Wrong packetBandCount_02", (Object)new BigInteger(1, new byte[]{-1, 2, 2, 2, 2, 2, 2, 2}), (Object)((MeterBandStats)((MeterStats)message.getMeterStats().get(0)).getMeterBandStats().get(1)).getPacketBandCount());
        Assert.assertEquals((String)"Wrong byteBandCount_02", (Object)new BigInteger(1, new byte[]{-1, 2, 2, 2, 2, 2, 2, 2}), (Object)((MeterBandStats)((MeterStats)message.getMeterStats().get(0)).getMeterBandStats().get(1)).getByteBandCount());
        Assert.assertEquals((String)"Wrong packetBandCount_03", (Object)new BigInteger(1, new byte[]{-1, 3, 3, 3, 3, 3, 3, 3}), (Object)((MeterBandStats)((MeterStats)message.getMeterStats().get(0)).getMeterBandStats().get(2)).getPacketBandCount());
        Assert.assertEquals((String)"Wrong byteBandCount_03", (Object)new BigInteger(1, new byte[]{-1, 3, 3, 3, 3, 3, 3, 3}), (Object)((MeterBandStats)((MeterStats)message.getMeterStats().get(0)).getMeterBandStats().get(2)).getByteBandCount());
        Assert.assertEquals((String)"Wrong meterId", (long)8L, (long)((MeterStats)message.getMeterStats().get(1)).getMeterId().getValue().intValue());
        Assert.assertEquals((String)"Wrong flowCount", (long)7L, (long)((MeterStats)message.getMeterStats().get(1)).getFlowCount().intValue());
        Assert.assertEquals((String)"Wrong packetInCount", (Object)new BigInteger(1, new byte[]{-1, 1, 1, 1, 1, 1, 1, 1}), (Object)((MeterStats)message.getMeterStats().get(1)).getPacketInCount());
        Assert.assertEquals((String)"Wrong byteInCount", (Object)new BigInteger(1, new byte[]{-1, 1, 1, 1, 1, 1, 1, 1}), (Object)((MeterStats)message.getMeterStats().get(1)).getByteInCount());
        Assert.assertEquals((String)"Wrong durationSec", (long)5L, (long)((MeterStats)message.getMeterStats().get(1)).getDurationSec().intValue());
        Assert.assertEquals((String)"Wrong durationNsec", (long)5L, (long)((MeterStats)message.getMeterStats().get(1)).getDurationNsec().intValue());
        Assert.assertEquals((String)"Wrong packetBandCount_01", (Object)new BigInteger(1, new byte[]{-1, 1, 1, 1, 1, 1, 1, 1}), (Object)((MeterBandStats)((MeterStats)message.getMeterStats().get(1)).getMeterBandStats().get(0)).getPacketBandCount());
        Assert.assertEquals((String)"Wrong byteBandCount_01", (Object)new BigInteger(1, new byte[]{-1, 1, 1, 1, 1, 1, 1, 1}), (Object)((MeterBandStats)((MeterStats)message.getMeterStats().get(1)).getMeterBandStats().get(0)).getByteBandCount());
        Assert.assertEquals((String)"Wrong packetBandCount_02", (Object)new BigInteger(1, new byte[]{-1, 2, 2, 2, 2, 2, 2, 2}), (Object)((MeterBandStats)((MeterStats)message.getMeterStats().get(1)).getMeterBandStats().get(1)).getPacketBandCount());
        Assert.assertEquals((String)"Wrong byteBandCount_02", (Object)new BigInteger(1, new byte[]{-1, 2, 2, 2, 2, 2, 2, 2}), (Object)((MeterBandStats)((MeterStats)message.getMeterStats().get(1)).getMeterBandStats().get(1)).getByteBandCount());
        Assert.assertEquals((String)"Wrong packetBandCount_03", (Object)new BigInteger(1, new byte[]{-1, 3, 3, 3, 3, 3, 3, 3}), (Object)((MeterBandStats)((MeterStats)message.getMeterStats().get(1)).getMeterBandStats().get(2)).getPacketBandCount());
        Assert.assertEquals((String)"Wrong byteBandCount_03", (Object)new BigInteger(1, new byte[]{-1, 3, 3, 3, 3, 3, 3, 3}), (Object)((MeterBandStats)((MeterStats)message.getMeterStats().get(1)).getMeterBandStats().get(2)).getByteBandCount());
    }

    @Test
    public void testMultipartReplyMeterConfigBody() {
        ByteBuf bb = BufferHelper.buildBuffer("00 0A 00 01 00 00 00 00 00 28 00 0A 00 00 00 09 00 01 00 10 00 00 00 11 00 00 00 20 00 00 00 00 00 02 00 10 00 00 00 11 00 00 00 20 04 00 00 00");
        MultipartReplyMessage builtByFactory = BufferHelper.deserialize(this.multipartFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)10L, (long)builtByFactory.getType().getIntValue());
        Assert.assertEquals((String)"Wrong flag", (Object)true, (Object)builtByFactory.getFlags().isOFPMPFREQMORE());
        MultipartReplyMeterConfigCase messageCase = (MultipartReplyMeterConfigCase)builtByFactory.getMultipartReplyBody();
        MultipartReplyMeterConfig message = messageCase.getMultipartReplyMeterConfig();
        Assert.assertEquals((String)"Wrong flags", (Object)new MeterFlags(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true)), (Object)((MeterConfig)message.getMeterConfig().get(0)).getFlags());
        Assert.assertEquals((String)"Wrong meterId", (long)9L, (long)((MeterConfig)message.getMeterConfig().get(0)).getMeterId().getValue().intValue());
        MeterBandDropCase dropCase = (MeterBandDropCase)((Bands)((MeterConfig)message.getMeterConfig().get(0)).getBands().get(0)).getMeterBand();
        MeterBandDrop meterBandDrop = dropCase.getMeterBandDrop();
        Assert.assertEquals((String)"Wrong meterBandDrop.type", (long)1L, (long)meterBandDrop.getType().getIntValue());
        Assert.assertEquals((String)"Wrong meterBandDrop.rate", (long)17L, (long)meterBandDrop.getRate().intValue());
        Assert.assertEquals((String)"Wrong meterBandDrop.burstSize", (long)32L, (long)meterBandDrop.getBurstSize().intValue());
        MeterBandDscpRemarkCase dscpCase = (MeterBandDscpRemarkCase)((Bands)((MeterConfig)message.getMeterConfig().get(0)).getBands().get(1)).getMeterBand();
        MeterBandDscpRemark meterBandDscp = dscpCase.getMeterBandDscpRemark();
        Assert.assertEquals((String)"Wrong meterBandDscp.type", (long)2L, (long)meterBandDscp.getType().getIntValue());
        Assert.assertEquals((String)"Wrong meterBandDscp.rate", (long)17L, (long)meterBandDscp.getRate().intValue());
        Assert.assertEquals((String)"Wrong meterBandDscp.burstSize", (long)32L, (long)meterBandDscp.getBurstSize().intValue());
        Assert.assertEquals((String)"Wrong meterBandDscp.precLevel", (long)4L, (long)meterBandDscp.getPrecLevel().intValue());
    }

    @Test
    public void testMultipartReplyMeterConfigBodyMulti() {
        ByteBuf bb = BufferHelper.buildBuffer("00 0A 00 01 00 00 00 00 00 28 00 06 00 00 00 09 00 01 00 10 00 00 00 11 00 00 00 20 00 00 00 00 00 02 00 10 00 00 00 11 00 00 00 20 04 00 00 00 00 18 00 03 00 00 00 07 00 02 00 10 00 00 00 11 00 00 00 20 04 00 00 00");
        MultipartReplyMessage builtByFactory = BufferHelper.deserialize(this.multipartFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)10L, (long)builtByFactory.getType().getIntValue());
        Assert.assertEquals((String)"Wrong flag", (Object)true, (Object)builtByFactory.getFlags().isOFPMPFREQMORE());
        MultipartReplyMeterConfigCase messageCase = (MultipartReplyMeterConfigCase)builtByFactory.getMultipartReplyBody();
        MultipartReplyMeterConfig message = messageCase.getMultipartReplyMeterConfig();
        Assert.assertEquals((String)"Wrong flags", (Object)new MeterFlags(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)), (Object)((MeterConfig)message.getMeterConfig().get(0)).getFlags());
        Assert.assertEquals((String)"Wrong meterId", (long)9L, (long)((MeterConfig)message.getMeterConfig().get(0)).getMeterId().getValue().intValue());
        MeterBandDropCase dropCase = (MeterBandDropCase)((Bands)((MeterConfig)message.getMeterConfig().get(0)).getBands().get(0)).getMeterBand();
        MeterBandDrop meterBandDrop = dropCase.getMeterBandDrop();
        Assert.assertEquals((String)"Wrong meterBandDrop.type", (long)1L, (long)meterBandDrop.getType().getIntValue());
        Assert.assertEquals((String)"Wrong meterBandDrop.rate", (long)17L, (long)meterBandDrop.getRate().intValue());
        Assert.assertEquals((String)"Wrong meterBandDrop.burstSize", (long)32L, (long)meterBandDrop.getBurstSize().intValue());
        MeterBandDscpRemarkCase dscpCase = (MeterBandDscpRemarkCase)((Bands)((MeterConfig)message.getMeterConfig().get(0)).getBands().get(1)).getMeterBand();
        MeterBandDscpRemark meterBandDscp = dscpCase.getMeterBandDscpRemark();
        Assert.assertEquals((String)"Wrong meterBandDscp.type", (long)2L, (long)meterBandDscp.getType().getIntValue());
        Assert.assertEquals((String)"Wrong meterBandDscp.rate", (long)17L, (long)meterBandDscp.getRate().intValue());
        Assert.assertEquals((String)"Wrong meterBandDscp.burstSize", (long)32L, (long)meterBandDscp.getBurstSize().intValue());
        Assert.assertEquals((String)"Wrong meterBandDscp.precLevel", (long)4L, (long)meterBandDscp.getPrecLevel().intValue());
        LOG.info(((MeterConfig)message.getMeterConfig().get(0)).getFlags().toString());
        Assert.assertEquals((String)"Wrong flags01", (Object)new MeterFlags(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false)), (Object)((MeterConfig)message.getMeterConfig().get(1)).getFlags());
        Assert.assertEquals((String)"Wrong meterId01", (long)7L, (long)((MeterConfig)message.getMeterConfig().get(1)).getMeterId().getValue().intValue());
        MeterBandDscpRemarkCase dscpCase01 = (MeterBandDscpRemarkCase)((Bands)((MeterConfig)message.getMeterConfig().get(1)).getBands().get(0)).getMeterBand();
        MeterBandDscpRemark meterBandDscp01 = dscpCase01.getMeterBandDscpRemark();
        Assert.assertEquals((String)"Wrong meterBandDscp01.type", (long)2L, (long)meterBandDscp01.getType().getIntValue());
        Assert.assertEquals((String)"Wrong meterBandDscp01.rate", (long)17L, (long)meterBandDscp01.getRate().intValue());
        Assert.assertEquals((String)"Wrong meterBandDscp01.burstSize", (long)32L, (long)meterBandDscp01.getBurstSize().intValue());
        Assert.assertEquals((String)"Wrong meterBandDscp01.precLevel", (long)4L, (long)meterBandDscp01.getPrecLevel().intValue());
    }

    @Test
    public void testMultipartReplyGroupDescBody01() {
        ByteBuf bb = BufferHelper.buildBuffer("00 07 00 01 00 00 00 00 00 38 01 00 00 00 00 08 00 30 00 06 00 00 00 05 00 00 00 04 00 00 00 00 00 00 00 10 00 00 10 FF FF FF 00 00 00 00 00 00 00 0B 00 08 00 00 00 00 00 0C 00 08 00 00 00 00");
        MultipartReplyMessage builtByFactory = BufferHelper.deserialize(this.multipartFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)7L, (long)builtByFactory.getType().getIntValue());
        Assert.assertEquals((String)"Wrong flag", (Object)true, (Object)builtByFactory.getFlags().isOFPMPFREQMORE());
        MultipartReplyGroupDescCase messageCase = (MultipartReplyGroupDescCase)builtByFactory.getMultipartReplyBody();
        MultipartReplyGroupDesc message = messageCase.getMultipartReplyGroupDesc();
        Assert.assertEquals((String)"Wrong type", (long)1L, (long)((GroupDesc)message.getGroupDesc().get(0)).getType().getIntValue());
        Assert.assertEquals((String)"Wrong groupId", (long)8L, (long)((GroupDesc)message.getGroupDesc().get(0)).getGroupId().getValue().intValue());
        Assert.assertEquals((String)"Wrong bucketWeight", (long)6L, (long)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getWeight().intValue());
        Assert.assertEquals((String)"Wrong bucketWatchPort", (long)5L, (long)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getWatchPort().getValue().intValue());
        Assert.assertEquals((String)"Wrong bucketWatchGroup", (long)4L, (long)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getWatchGroup().intValue());
        Assert.assertTrue((String)"Wrong outputType", (boolean)(((Action)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getAction().get(0)).getActionChoice() instanceof OutputActionCase));
        Assert.assertEquals((String)"Wrong outputPort", (long)4351L, (long)((OutputActionCase)((Action)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getAction().get(0)).getActionChoice()).getOutputAction().getPort().getValue().intValue());
        Assert.assertEquals((String)"Wrong outputMaxLen", (long)65535L, (long)((OutputActionCase)((Action)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getAction().get(0)).getActionChoice()).getOutputAction().getMaxLength().intValue());
        Assert.assertTrue((String)"Wrong copyTtlOutType", (boolean)(((Action)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getAction().get(1)).getActionChoice() instanceof CopyTtlOutCase));
        Assert.assertTrue((String)"Wrong copyTtlInType", (boolean)(((Action)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getAction().get(2)).getActionChoice() instanceof CopyTtlInCase));
    }

    @Test
    public void testMultipartReplyGroupDescBody02() {
        ByteBuf bb = BufferHelper.buildBuffer("00 07 00 01 00 00 00 00 00 40 01 00 00 00 00 08 00 38 00 06 00 00 00 05 00 00 00 04 00 00 00 00 00 0F 00 08 09 00 00 00 00 10 00 08 00 00 00 00 00 11 00 08 00 20 00 00 00 13 00 08 00 FF 00 00 00 1A 00 08 0F FF 00 00");
        MultipartReplyMessage builtByFactory = BufferHelper.deserialize(this.multipartFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)7L, (long)builtByFactory.getType().getIntValue());
        Assert.assertEquals((String)"Wrong flag", (Object)true, (Object)builtByFactory.getFlags().isOFPMPFREQMORE());
        MultipartReplyGroupDescCase messageCase = (MultipartReplyGroupDescCase)builtByFactory.getMultipartReplyBody();
        MultipartReplyGroupDesc message = messageCase.getMultipartReplyGroupDesc();
        Assert.assertEquals((String)"Wrong type", (long)1L, (long)((GroupDesc)message.getGroupDesc().get(0)).getType().getIntValue());
        Assert.assertEquals((String)"Wrong groupId", (long)8L, (long)((GroupDesc)message.getGroupDesc().get(0)).getGroupId().getValue().intValue());
        Assert.assertEquals((String)"Wrong bucketWeight", (long)6L, (long)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getWeight().intValue());
        Assert.assertEquals((String)"Wrong bucketWatchPort", (long)5L, (long)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getWatchPort().getValue().intValue());
        Assert.assertEquals((String)"Wrong bucketWatchGroup", (long)4L, (long)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getWatchGroup().intValue());
        Assert.assertTrue((String)"Wrong setMplsTtlType", (boolean)(((Action)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getAction().get(0)).getActionChoice() instanceof SetMplsTtlCase));
        Assert.assertEquals((String)"Wrong setMplsTtlMPLS_TTL", (long)9L, (long)((SetMplsTtlCase)((Action)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getAction().get(0)).getActionChoice()).getSetMplsTtlAction().getMplsTtl().intValue());
        Assert.assertTrue((String)"Wrong decMplsTtlType", (boolean)(((Action)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getAction().get(1)).getActionChoice() instanceof DecMplsTtlCase));
        Assert.assertTrue((String)"Wrong pushVlanType", (boolean)(((Action)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getAction().get(2)).getActionChoice() instanceof PushVlanCase));
        Assert.assertEquals((String)"Wrong pushVlanEthertype", (long)32L, (long)((PushVlanCase)((Action)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getAction().get(2)).getActionChoice()).getPushVlanAction().getEthertype().getValue().intValue());
        Assert.assertTrue((String)"Wrong pushMplsType", (boolean)(((Action)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getAction().get(3)).getActionChoice() instanceof PushMplsCase));
        Assert.assertEquals((String)"Wrong pushMplsEthertype", (long)255L, (long)((PushMplsCase)((Action)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getAction().get(3)).getActionChoice()).getPushMplsAction().getEthertype().getValue().intValue());
        Assert.assertTrue((String)"Wrong pushPbbType", (boolean)(((Action)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getAction().get(4)).getActionChoice() instanceof PushPbbCase));
        Assert.assertEquals((String)"Wrong pushPbbEthertype", (long)4095L, (long)((PushPbbCase)((Action)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getAction().get(4)).getActionChoice()).getPushPbbAction().getEthertype().getValue().intValue());
    }

    @Test
    public void testMultipartReplyGroupDescBody03() {
        ByteBuf bb = BufferHelper.buildBuffer("00 07 00 01 00 00 00 00 00 48 01 00 00 00 00 08 00 40 00 06 00 00 00 05 00 00 00 04 00 00 00 00 00 12 00 08 00 00 00 00 00 1B 00 08 00 00 00 00 00 14 00 08 00 CF 00 00 00 15 00 08 00 CF 00 00 00 16 00 08 00 CF 00 00 00 18 00 08 00 00 00 00");
        MultipartReplyMessage builtByFactory = BufferHelper.deserialize(this.multipartFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)7L, (long)builtByFactory.getType().getIntValue());
        Assert.assertEquals((String)"Wrong flag", (Object)true, (Object)builtByFactory.getFlags().isOFPMPFREQMORE());
        MultipartReplyGroupDescCase messageCase = (MultipartReplyGroupDescCase)builtByFactory.getMultipartReplyBody();
        MultipartReplyGroupDesc message = messageCase.getMultipartReplyGroupDesc();
        Assert.assertEquals((String)"Wrong type", (long)1L, (long)((GroupDesc)message.getGroupDesc().get(0)).getType().getIntValue());
        Assert.assertEquals((String)"Wrong groupId", (long)8L, (long)((GroupDesc)message.getGroupDesc().get(0)).getGroupId().getValue().intValue());
        Assert.assertEquals((String)"Wrong bucketWeight", (long)6L, (long)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getWeight().intValue());
        Assert.assertEquals((String)"Wrong bucketWatchPort", (long)5L, (long)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getWatchPort().getValue().intValue());
        Assert.assertEquals((String)"Wrong bucketWatchGroup", (long)4L, (long)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getWatchGroup().intValue());
        Assert.assertTrue((String)"Wrong popVlanType", (boolean)(((Action)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getAction().get(0)).getActionChoice() instanceof PopVlanCase));
        Assert.assertTrue((String)"Wrong popPbbType", (boolean)(((Action)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getAction().get(1)).getActionChoice() instanceof PopPbbCase));
        Assert.assertTrue((String)"Wrong popMplsType", (boolean)(((Action)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getAction().get(2)).getActionChoice() instanceof PopMplsCase));
        Assert.assertEquals((String)"Wrong popMplsEthertype", (long)207L, (long)((PopMplsCase)((Action)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getAction().get(2)).getActionChoice()).getPopMplsAction().getEthertype().getValue().intValue());
        Assert.assertTrue((String)"Wrong setQueueType", (boolean)(((Action)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getAction().get(3)).getActionChoice() instanceof SetQueueCase));
        Assert.assertEquals((String)"Wrong setQueueQueueId", (long)0xCF0000L, (long)((SetQueueCase)((Action)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getAction().get(3)).getActionChoice()).getSetQueueAction().getQueueId().intValue());
        Assert.assertTrue((String)"Wrong groupType", (boolean)(((Action)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getAction().get(4)).getActionChoice() instanceof GroupCase));
        Assert.assertEquals((String)"Wrong groupGroupId", (long)0xCF0000L, (long)((GroupCase)((Action)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getAction().get(4)).getActionChoice()).getGroupAction().getGroupId().intValue());
        Assert.assertTrue((String)"Wrong decNwTtlType", (boolean)(((Action)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getAction().get(5)).getActionChoice() instanceof DecNwTtlCase));
    }

    @Test
    public void testMultipartReplyGroupDescBody04() {
        ByteBuf bb = BufferHelper.buildBuffer("00 07 00 01 00 00 00 00 00 30 01 00 00 00 00 08 00 28 00 06 00 00 00 05 00 00 00 04 00 00 00 00 00 17 00 08 0E 00 00 00 00 19 00 10 80 00 00 04 00 00 00 FF 00 00 00 00");
        MultipartReplyMessage builtByFactory = BufferHelper.deserialize(this.multipartFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)7L, (long)builtByFactory.getType().getIntValue());
        Assert.assertEquals((String)"Wrong flag", (Object)true, (Object)builtByFactory.getFlags().isOFPMPFREQMORE());
        MultipartReplyGroupDescCase messageCase = (MultipartReplyGroupDescCase)builtByFactory.getMultipartReplyBody();
        MultipartReplyGroupDesc message = messageCase.getMultipartReplyGroupDesc();
        Assert.assertEquals((String)"Wrong type", (long)1L, (long)((GroupDesc)message.getGroupDesc().get(0)).getType().getIntValue());
        Assert.assertEquals((String)"Wrong groupId", (long)8L, (long)((GroupDesc)message.getGroupDesc().get(0)).getGroupId().getValue().intValue());
        Assert.assertEquals((String)"Wrong bucketWeight", (long)6L, (long)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getWeight().intValue());
        Assert.assertEquals((String)"Wrong bucketWatchPort", (long)5L, (long)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getWatchPort().getValue().intValue());
        Assert.assertEquals((String)"Wrong bucketWatchGroup", (long)4L, (long)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getWatchGroup().intValue());
        Assert.assertTrue((String)"Wrong nwTTlType", (boolean)(((Action)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getAction().get(0)).getActionChoice() instanceof SetNwTtlCase));
        Assert.assertEquals((String)"Wrong nwTTlnwTTL", (long)14L, (long)((SetNwTtlCase)((Action)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getAction().get(0)).getActionChoice()).getSetNwTtlAction().getNwTtl().intValue());
        Assert.assertTrue((String)"Wrong setFieldType", (boolean)(((Action)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getAction().get(1)).getActionChoice() instanceof SetFieldCase));
        Assert.assertEquals((String)"Wrong setFieldOXMClass", OpenflowBasicClass.class, (Object)((MatchEntry)((SetFieldCase)((Action)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getAction().get(1)).getActionChoice()).getSetFieldAction().getMatchEntry().get(0)).getOxmClass());
        Assert.assertEquals((String)"Wrong setFieldOXMField", InPort.class, (Object)((MatchEntry)((SetFieldCase)((Action)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getAction().get(1)).getActionChoice()).getSetFieldAction().getMatchEntry().get(0)).getOxmMatchField());
        MatchEntry entry = (MatchEntry)((SetFieldCase)((Action)((BucketsList)((GroupDesc)message.getGroupDesc().get(0)).getBucketsList().get(0)).getAction().get(1)).getActionChoice()).getSetFieldAction().getMatchEntry().get(0);
        Assert.assertEquals((String)"Wrong setFieldOXMValue", (long)255L, (long)((InPortCase)entry.getMatchEntryValue()).getInPort().getPortNumber().getValue().intValue());
    }
}

