/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import java.math.BigInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartRequestFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartRequestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestFlowCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestFlowCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.flow._case.MultipartRequestFlowBuilder;

public class MultipartRequestFlowInputMessageFactoryTest {
    private OFDeserializer<MultipartRequestInput> factory;

    @Before
    public void startUp() {
        DeserializerRegistryImpl desRegistry = new DeserializerRegistryImpl();
        desRegistry.init();
        this.factory = (OFDeserializer)desRegistry.getDeserializer(new MessageCodeKey(4, 18, MultipartRequestInput.class));
    }

    @Test
    public void test() {
        ByteBuf bb = BufferHelper.buildBuffer("00 01 00 01 00 00 00 00 08 00 00 00 00 00 00 55 00 00 00 5f 00 00 00 00 00 01 01 01 01 01 01 01 00 01 01 01 01 01 01 01");
        MultipartRequestInput deserializedMessage = BufferHelper.deserialize(this.factory, bb);
        BufferHelper.checkHeaderV13((OfHeader)deserializedMessage);
        Assert.assertEquals((String)"Wrong type", (Object)MultipartType.forValue((int)1), (Object)deserializedMessage.getType());
        Assert.assertEquals((String)"Wrong flags", (Object)new MultipartRequestFlags(Boolean.valueOf(true)), (Object)deserializedMessage.getFlags());
        Assert.assertEquals((String)"Wrong flow", (Object)MultipartRequestFlowInputMessageFactoryTest.createRequestFlow(), (Object)deserializedMessage.getMultipartRequestBody());
    }

    private static MultipartRequestFlowCase createRequestFlow() {
        MultipartRequestFlowCaseBuilder caseBuilder = new MultipartRequestFlowCaseBuilder();
        MultipartRequestFlowBuilder builder = new MultipartRequestFlowBuilder();
        builder.setTableId(Short.valueOf((short)8));
        builder.setOutPort(Long.valueOf(85L));
        builder.setOutGroup(Long.valueOf(95L));
        byte[] cookie = new byte[]{0, 1, 1, 1, 1, 1, 1, 1};
        builder.setCookie(new BigInteger(1, cookie));
        byte[] cookieMask = new byte[]{0, 1, 1, 1, 1, 1, 1, 1};
        builder.setCookieMask(new BigInteger(1, cookieMask));
        caseBuilder.setMultipartRequestFlow(builder.build());
        return caseBuilder.build();
    }
}

