/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.deserialization.factories.MultipartRequestInputMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartRequestFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartRequestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestGroupCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestGroupCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.group._case.MultipartRequestGroupBuilder;

public class MultipartRequestGroupInputMessageFactoryTest {
    ByteBuf bb = BufferHelper.buildBuffer("00 06 00 01 00 00 00 00 00 00 08 d2 00 00 00 00");
    MultipartRequestInputMessageFactory factory;
    MultipartRequestInput deserializedMessage;

    @Before
    public void startUp() {
        DeserializerRegistryImpl desRegistry = new DeserializerRegistryImpl();
        desRegistry.init();
        this.factory = (MultipartRequestInputMessageFactory)desRegistry.getDeserializer(new MessageCodeKey(4, 18, MultipartRequestInput.class));
    }

    @Test
    public void test() {
        this.deserializedMessage = (MultipartRequestInput)BufferHelper.deserialize(this.factory, this.bb);
        BufferHelper.checkHeaderV13((OfHeader)this.deserializedMessage);
        Assert.assertEquals((String)"Wrong type", (Object)MultipartType.forValue((int)6), (Object)this.deserializedMessage.getType());
        Assert.assertEquals((String)"Wrong flags", (Object)new MultipartRequestFlags(Boolean.valueOf(true)), (Object)this.deserializedMessage.getFlags());
        Assert.assertEquals((String)"Wrong aggregate", (Object)MultipartRequestGroupInputMessageFactoryTest.createRequestGroup(), (Object)this.deserializedMessage.getMultipartRequestBody());
    }

    private static MultipartRequestGroupCase createRequestGroup() {
        MultipartRequestGroupCaseBuilder caseBuilder = new MultipartRequestGroupCaseBuilder();
        MultipartRequestGroupBuilder builder = new MultipartRequestGroupBuilder();
        builder.setGroupId(new GroupId(Long.valueOf(2258L)));
        caseBuilder.setMultipartRequestGroup(builder.build());
        return caseBuilder.build();
    }
}

