/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.EchoOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;

public class OF10EchoReplyMessageFactoryTest {
    private OFDeserializer<EchoOutput> echoFactory;

    @Before
    public void startUp() {
        DeserializerRegistryImpl registry = new DeserializerRegistryImpl();
        registry.init();
        this.echoFactory = (OFDeserializer)registry.getDeserializer(new MessageCodeKey(1, 3, EchoOutput.class));
    }

    @Test
    public void testWithEmptyDataFieldV10() {
        ByteBuf bb = BufferHelper.buildBuffer();
        EchoOutput builtByFactory = BufferHelper.deserialize(this.echoFactory, bb);
        BufferHelper.checkHeaderV10((OfHeader)builtByFactory);
    }

    @Test
    public void testWithDataFieldSetV10() {
        byte[] data = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
        ByteBuf bb = BufferHelper.buildBuffer(data);
        EchoOutput builtByFactory = BufferHelper.deserialize(this.echoFactory, bb);
        BufferHelper.checkHeaderV10((OfHeader)builtByFactory);
        Assert.assertArrayEquals((String)"Wrong data", (byte[])data, (byte[])builtByFactory.getData());
    }
}

