/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ErrorMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;

public class OF10ErrorMessageFactoryTest {
    private OFDeserializer<ErrorMessage> errorFactory;

    @Before
    public void startUp() {
        DeserializerRegistryImpl registry = new DeserializerRegistryImpl();
        registry.init();
        this.errorFactory = (OFDeserializer)registry.getDeserializer(new MessageCodeKey(1, 1, ErrorMessage.class));
    }

    @Test
    public void testWithoutData() {
        ByteBuf bb = BufferHelper.buildBuffer("00 00 00 00");
        ErrorMessage builtByFactory = BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV10((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)0L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)0L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"HELLOFAILED", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"INCOMPATIBLE", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
        bb = BufferHelper.buildBuffer("00 01 00 00");
        builtByFactory = BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV10((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)1L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)0L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"BADREQUEST", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"BADVERSION", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
        bb = BufferHelper.buildBuffer("00 02 00 00");
        builtByFactory = BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV10((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)2L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)0L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"BADACTION", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"BADTYPE", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
        bb = BufferHelper.buildBuffer("00 03 00 00");
        builtByFactory = BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV10((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)3L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)0L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"FLOWMODFAILED", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"ALLTABLESFULL", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
        bb = BufferHelper.buildBuffer("00 04 00 00");
        builtByFactory = BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV10((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)4L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)0L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"PORTMODFAILED", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"BADPORT", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
        bb = BufferHelper.buildBuffer("00 05 00 00");
        builtByFactory = BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV10((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)5L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)0L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"QUEUEOPFAILED", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"BADPORT", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
    }

    @Test
    public void testWithoutData2() {
        ByteBuf bb = BufferHelper.buildBuffer("00 00 FF FF");
        ErrorMessage builtByFactory = BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV10((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)0L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)65535L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"HELLOFAILED", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"UNKNOWN_CODE", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
        bb = BufferHelper.buildBuffer("00 01 FF FF");
        builtByFactory = BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV10((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)1L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)65535L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"BADREQUEST", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"UNKNOWN_CODE", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
        bb = BufferHelper.buildBuffer("00 02 FF FF");
        builtByFactory = BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV10((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)2L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)65535L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"BADACTION", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"UNKNOWN_CODE", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
        bb = BufferHelper.buildBuffer("00 03 FF FF");
        builtByFactory = BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV10((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)3L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)65535L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"FLOWMODFAILED", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"UNKNOWN_CODE", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
        bb = BufferHelper.buildBuffer("00 04 FF FF");
        builtByFactory = BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV10((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)4L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)65535L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"PORTMODFAILED", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"UNKNOWN_CODE", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
        bb = BufferHelper.buildBuffer("00 05 FF FF");
        builtByFactory = BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV10((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)5L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)65535L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"QUEUEOPFAILED", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"UNKNOWN_CODE", (Object)builtByFactory.getCodeString());
        Assert.assertNull((String)"Data is not null", (Object)builtByFactory.getData());
    }

    @Test
    public void testWithData() {
        ByteBuf bb = BufferHelper.buildBuffer("00 00 00 01 00 01 02 03");
        ErrorMessage builtByFactory = BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV10((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)0L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)1L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"HELLOFAILED", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"EPERM", (Object)builtByFactory.getCodeString());
        Assert.assertArrayEquals((String)"Wrong data", (byte[])new byte[]{0, 1, 2, 3}, (byte[])builtByFactory.getData());
    }

    @Test
    public void testWithIncorrectTypeEnum() {
        ByteBuf bb = BufferHelper.buildBuffer("00 0A 00 05 00 01 02 03");
        ErrorMessage builtByFactory = BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV10((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)10L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)5L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"UNKNOWN_TYPE", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"UNKNOWN_CODE", (Object)builtByFactory.getCodeString());
        Assert.assertArrayEquals((String)"Wrong data", (byte[])new byte[]{0, 1, 2, 3}, (byte[])builtByFactory.getData());
    }

    @Test
    public void testWithIncorrectCodeEnum() {
        ByteBuf bb = BufferHelper.buildBuffer("00 03 00 06 00 01 02 03");
        ErrorMessage builtByFactory = BufferHelper.deserialize(this.errorFactory, bb);
        BufferHelper.checkHeaderV10((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)3L, (long)builtByFactory.getType().intValue());
        Assert.assertEquals((String)"Wrong code", (long)6L, (long)builtByFactory.getCode().intValue());
        Assert.assertEquals((String)"Wrong type string", (Object)"FLOWMODFAILED", (Object)builtByFactory.getTypeString());
        Assert.assertEquals((String)"Wrong code string", (Object)"UNKNOWN_CODE", (Object)builtByFactory.getCodeString());
        Assert.assertArrayEquals((String)"Wrong data", (byte[])new byte[]{0, 1, 2, 3}, (byte[])builtByFactory.getData());
    }
}

