/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ActionTypeV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.CapabilitiesV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortConfigV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortFeaturesV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortStateV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetFeaturesOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.features.reply.PhyPort;

public class OF10FeaturesReplyMessageFactoryTest {
    private OFDeserializer<GetFeaturesOutput> featuresFactory;

    @Before
    public void startUp() {
        DeserializerRegistryImpl registry = new DeserializerRegistryImpl();
        registry.init();
        this.featuresFactory = (OFDeserializer)registry.getDeserializer(new MessageCodeKey(1, 6, GetFeaturesOutput.class));
    }

    @Test
    public void test() {
        ByteBuf bb = BufferHelper.buildBuffer("00 01 02 03 04 05 06 07 00 01 02 03 01 00 00 00 00 00 00 FF 00 00 0F FF 00 10 01 01 05 01 04 02 41 4C 4F 48 41 00 00 00 00 00 00 00 00 00 00 00 00 00 00 7F 00 00 02 00 00 00 0F FF 00 00 00 00 00 00 03 0C 00 00 08 88");
        GetFeaturesOutput builtByFactory = BufferHelper.deserialize(this.featuresFactory, bb);
        BufferHelper.checkHeaderV10((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong datapathId", (long)283686952306183L, (long)builtByFactory.getDatapathId().longValue());
        Assert.assertEquals((String)"Wrong n-buffers", (long)66051L, (long)builtByFactory.getBuffers());
        Assert.assertEquals((String)"Wrong n-tables", (long)1L, (long)builtByFactory.getTables().shortValue());
        Assert.assertEquals((String)"Wrong capabilities", (Object)new CapabilitiesV10(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true)), (Object)builtByFactory.getCapabilitiesV10());
        Assert.assertEquals((String)"Wrong actions", (Object)new ActionTypeV10(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false)), (Object)builtByFactory.getActionsV10());
        PhyPort port = (PhyPort)builtByFactory.getPhyPort().get(0);
        Assert.assertEquals((String)"Wrong port - port-no", (long)16L, (long)port.getPortNo().intValue());
        Assert.assertEquals((String)"Wrong port - hw-addr", (Object)new MacAddress("01:01:05:01:04:02"), (Object)port.getHwAddr());
        Assert.assertEquals((String)"Wrong port - name", (Object)new String("ALOHA"), (Object)port.getName());
        Assert.assertEquals((String)"Wrong port - config", (Object)new PortConfigV10(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true)), (Object)port.getConfigV10());
        Assert.assertEquals((String)"Wrong port - state", (Object)new PortStateV10(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)), (Object)port.getStateV10());
        Assert.assertEquals((String)"Wrong port - curr", (Object)new PortFeaturesV10(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true)), (Object)port.getCurrentFeaturesV10());
        Assert.assertEquals((String)"Wrong port - advertised", (Object)new PortFeaturesV10(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false)), (Object)port.getAdvertisedFeaturesV10());
        Assert.assertEquals((String)"Wrong port - supported", (Object)new PortFeaturesV10(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false)), (Object)port.getSupportedFeaturesV10());
        Assert.assertEquals((String)"Wrong port - peer", (Object)new PortFeaturesV10(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true)), (Object)port.getPeerFeaturesV10());
    }

    @Test
    public void testWithTwoPortsSet() {
        ByteBuf bb = BufferHelper.buildBuffer("00 01 02 03 04 05 06 07 00 01 02 03 01 00 00 00 00 00 00 8B 00 00 03 B5 00 10 01 01 05 01 04 02 41 4C 4F 48 41 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 07 01 00 00 00 31 00 00 04 42 00 00 03 0C 00 00 08 88 00 10 01 01 05 01 04 02 41 4C 4F 48 41 00 00 00 00 00 00 00 00 00 00 00 00 00 00 15 00 00 00 00 00 00 00 31 00 00 04 42 00 00 03 0C 00 00 08 88");
        GetFeaturesOutput builtByFactory = BufferHelper.deserialize(this.featuresFactory, bb);
        BufferHelper.checkHeaderV10((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong ports size", (long)2L, (long)builtByFactory.getPhyPort().size());
        PhyPort port = (PhyPort)builtByFactory.getPhyPort().get(0);
        Assert.assertEquals((String)"Wrong port - port-no", (long)16L, (long)port.getPortNo().intValue());
        Assert.assertEquals((String)"Wrong port - hw-addr", (Object)new MacAddress("01:01:05:01:04:02"), (Object)port.getHwAddr());
        Assert.assertEquals((String)"Wrong port - name", (Object)new String("ALOHA"), (Object)port.getName());
        Assert.assertEquals((String)"Wrong port - config", (Object)new PortConfigV10(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false)), (Object)port.getConfigV10());
        Assert.assertEquals((String)"Wrong port - state", (Object)new PortStateV10(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true)), (Object)port.getStateV10());
        port = (PhyPort)builtByFactory.getPhyPort().get(1);
        Assert.assertEquals((String)"Wrong port - state", (Object)new PortStateV10(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)), (Object)port.getStateV10());
    }

    @Test
    public void testWithNoPortsSet() {
        ByteBuf bb = BufferHelper.buildBuffer("00 01 02 03 04 05 06 07 00 01 02 03 01 00 00 00 00 00 00 00 00 00 00 00");
        GetFeaturesOutput builtByFactory = BufferHelper.deserialize(this.featuresFactory, bb);
        BufferHelper.checkHeaderV10((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong capabilities", (Object)new CapabilitiesV10(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false)), (Object)builtByFactory.getCapabilitiesV10());
        Assert.assertEquals((String)"Wrong actions", (Object)new ActionTypeV10(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false)), (Object)builtByFactory.getActionsV10());
        Assert.assertEquals((String)"Wrong ports size", (long)0L, (long)builtByFactory.getPhyPort().size());
    }
}

