/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.ActionChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetNwDstCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetTpSrcCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.set.nw.dst._case.SetNwDstActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.set.tp.src._case.SetTpSrcActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.ActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowModCommand;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowModFlagsV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowWildcardsV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.v10.grouping.MatchV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.v10.grouping.MatchV10Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;

public class OF10FlowModInputMessageFactoryTest {
    private OFDeserializer<FlowModInput> factory;

    @Before
    public void startUp() {
        DeserializerRegistryImpl desRegistry = new DeserializerRegistryImpl();
        desRegistry.init();
        this.factory = (OFDeserializer)desRegistry.getDeserializer(new MessageCodeKey(1, 14, FlowModInput.class));
    }

    @Test
    public void test() {
        ByteBuf bb = BufferHelper.buildBuffer("00 38 20 ff 00 3a 01 01 01 01 01 01 ff ff ff ff ff ff 00 12 05 00 00 2a 04 07 00 00 08 08 08 08 10 10 10 10 19 fd 19 e9 ff 01 04 01 06 00 07 01 00 00 00 0c 00 10 00 01 00 00 00 02 11 46 00 03 00 07 00 08 02 02 02 02 00 09 00 08 00 2a 00 00 ");
        FlowModInput deserializedMessage = BufferHelper.deserialize(this.factory, bb);
        BufferHelper.checkHeaderV10((OfHeader)deserializedMessage);
        Assert.assertEquals((String)"Wrong Match", (Object)OF10FlowModInputMessageFactoryTest.createMatch(), (Object)deserializedMessage.getMatchV10());
        byte[] cookie = new byte[]{-1, 1, 4, 1, 6, 0, 7, 1};
        Assert.assertEquals((String)"Wrong cookie", (Object)new BigInteger(1, cookie), (Object)deserializedMessage.getCookie());
        Assert.assertEquals((String)"Wrong command", (Object)FlowModCommand.forValue((int)0), (Object)deserializedMessage.getCommand());
        Assert.assertEquals((String)"Idle Timeout", (long)12L, (long)deserializedMessage.getIdleTimeout().intValue());
        Assert.assertEquals((String)"Wrong Hard Timeout", (long)16L, (long)deserializedMessage.getHardTimeout().intValue());
        Assert.assertEquals((String)"Wrong priority", (long)1L, (long)deserializedMessage.getPriority().intValue());
        Assert.assertEquals((String)"Wrong buffer id", (long)2L, (long)deserializedMessage.getBufferId());
        Assert.assertEquals((String)"Wrong out port", (Object)new PortNumber(Long.valueOf(4422L)), (Object)deserializedMessage.getOutPort());
        Assert.assertEquals((String)"Wrong flags", (Object)new FlowModFlagsV10(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true)), (Object)deserializedMessage.getFlagsV10());
        Assert.assertEquals((String)"Wrong actions", OF10FlowModInputMessageFactoryTest.createAction(), (Object)deserializedMessage.getAction());
    }

    private static List<Action> createAction() {
        ArrayList<Action> actions = new ArrayList<Action>();
        ActionBuilder actionBuilder = new ActionBuilder();
        SetNwDstCaseBuilder nwDstCaseBuilder = new SetNwDstCaseBuilder();
        SetNwDstActionBuilder nwDstBuilder = new SetNwDstActionBuilder();
        nwDstBuilder.setIpAddress(new Ipv4Address("2.2.2.2"));
        nwDstCaseBuilder.setSetNwDstAction(nwDstBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)nwDstCaseBuilder.build());
        actions.add(actionBuilder.build());
        actionBuilder = new ActionBuilder();
        SetTpSrcCaseBuilder tpSrcCaseBuilder = new SetTpSrcCaseBuilder();
        SetTpSrcActionBuilder tpSrcBuilder = new SetTpSrcActionBuilder();
        tpSrcBuilder.setPort(new PortNumber(Long.valueOf(42L)));
        tpSrcCaseBuilder.setSetTpSrcAction(tpSrcBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)tpSrcCaseBuilder.build());
        actions.add(actionBuilder.build());
        return actions;
    }

    private static MatchV10 createMatch() {
        MatchV10Builder matchBuilder = new MatchV10Builder();
        matchBuilder.setWildcards(new FlowWildcardsV10(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true)));
        matchBuilder.setNwSrcMask(Short.valueOf((short)0));
        matchBuilder.setNwDstMask(Short.valueOf((short)0));
        matchBuilder.setInPort(Integer.valueOf(58));
        matchBuilder.setDlSrc(new MacAddress("01:01:01:01:01:01"));
        matchBuilder.setDlDst(new MacAddress("ff:ff:ff:ff:ff:ff"));
        matchBuilder.setDlVlan(Integer.valueOf(18));
        matchBuilder.setDlVlanPcp(Short.valueOf((short)5));
        matchBuilder.setDlType(Integer.valueOf(42));
        matchBuilder.setNwTos(Short.valueOf((short)4));
        matchBuilder.setNwProto(Short.valueOf((short)7));
        matchBuilder.setNwSrc(new Ipv4Address("8.8.8.8"));
        matchBuilder.setNwDst(new Ipv4Address("16.16.16.16"));
        matchBuilder.setTpSrc(Integer.valueOf(6653));
        matchBuilder.setTpDst(Integer.valueOf(6633));
        return matchBuilder.build();
    }
}

