/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowRemovedMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;

public class OF10FlowRemovedMessageFactoryTest {
    private OFDeserializer<FlowRemovedMessage> flowFactory;

    @Before
    public void startUp() {
        DeserializerRegistryImpl registry = new DeserializerRegistryImpl();
        registry.init();
        this.flowFactory = (OFDeserializer)registry.getDeserializer(new MessageCodeKey(1, 11, FlowRemovedMessage.class));
    }

    @Test
    public void test() {
        ByteBuf bb = BufferHelper.buildBuffer("00 24 08 D1 00 20 AA BB CC DD EE FF AA BB CC DD EE FF 00 05 10 00 00 08 07 06 00 00 10 11 12 13 01 02 03 04 50 50 20 20 00 01 02 03 04 05 06 07 00 03 01 00 00 00 00 02 00 00 00 05 00 08 00 00 00 01 02 03 04 05 06 07 00 01 02 03 04 05 06 07");
        FlowRemovedMessage builtByFactory = BufferHelper.deserialize(this.flowFactory, bb);
        BufferHelper.checkHeaderV10((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong cookie", (long)283686952306183L, (long)builtByFactory.getCookie().longValue());
        Assert.assertEquals((String)"Wrong priority", (long)3L, (long)builtByFactory.getPriority().intValue());
        Assert.assertEquals((String)"Wrong reason", (long)1L, (long)builtByFactory.getReason().getIntValue());
        Assert.assertEquals((String)"Wrong durationSec", (long)2L, (long)builtByFactory.getDurationSec());
        Assert.assertEquals((String)"Wrong durationNsec", (long)5L, (long)builtByFactory.getDurationNsec());
        Assert.assertEquals((String)"Wrong idleTimeout", (long)8L, (long)builtByFactory.getIdleTimeout().intValue());
        Assert.assertEquals((String)"Wrong packetCount", (long)283686952306183L, (long)builtByFactory.getPacketCount().longValue());
        Assert.assertEquals((String)"Wrong byteCount", (long)283686952306183L, (long)builtByFactory.getByteCount().longValue());
    }
}

