/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.HelloMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;

public class OF10HelloMessageFactoryTest {
    private OFDeserializer<HelloMessage> helloFactory;

    @Before
    public void startUp() {
        DeserializerRegistryImpl registry = new DeserializerRegistryImpl();
        registry.init();
        this.helloFactory = (OFDeserializer)registry.getDeserializer(new MessageCodeKey(1, 0, HelloMessage.class));
    }

    @Test
    public void testWithoutElements() {
        ByteBuf bb = BufferHelper.buildBuffer();
        HelloMessage builtByFactory = BufferHelper.deserialize(this.helloFactory, bb);
        BufferHelper.checkHeaderV10((OfHeader)builtByFactory);
        Assert.assertNull((String)"Wrong elements", (Object)builtByFactory.getElements());
    }

    @Test
    public void testWithElements() {
        ByteBuf bb = BufferHelper.buildBuffer("00 01 00 0c 00 00 00 11 00 00 00 00 00 00 00 00");
        HelloMessage builtByFactory = BufferHelper.deserialize(this.helloFactory, bb);
        BufferHelper.checkHeaderV10((OfHeader)builtByFactory);
        Assert.assertNull((String)"Wrong elements", (Object)builtByFactory.getElements());
    }
}

