/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PacketInReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketInMessage;

public class OF10PacketInMessageFactoryTest {
    private OFDeserializer<PacketInMessage> packetInFactory;

    @Before
    public void startUp() {
        DeserializerRegistryImpl registry = new DeserializerRegistryImpl();
        registry.init();
        this.packetInFactory = (OFDeserializer)registry.getDeserializer(new MessageCodeKey(1, 10, PacketInMessage.class));
    }

    @Test
    public void test() {
        ByteBuf bb = BufferHelper.buildBuffer("00 01 02 03 01 02 01 02 00 00 01 02 03 04");
        PacketInMessage builtByFactory = BufferHelper.deserialize(this.packetInFactory, bb);
        BufferHelper.checkHeaderV10((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong bufferID", (long)66051L, (long)builtByFactory.getBufferId());
        Assert.assertEquals((String)"Wrong totalLength", (long)258L, (long)builtByFactory.getTotalLen().intValue());
        Assert.assertEquals((String)"Wrong inPort", (long)258L, (long)builtByFactory.getInPort().intValue());
        Assert.assertEquals((String)"Wrong reason", (Object)PacketInReason.OFPRNOMATCH, (Object)builtByFactory.getReason());
        Assert.assertArrayEquals((String)"Wrong data", (byte[])ByteBufUtils.hexStringToBytes((String)"01 02 03 04"), (byte[])builtByFactory.getData());
    }

    @Test
    public void testWithNoAdditionalData() {
        ByteBuf bb = BufferHelper.buildBuffer("00 01 02 03 01 02 01 02 00 00");
        PacketInMessage builtByFactory = BufferHelper.deserialize(this.packetInFactory, bb);
        Assert.assertNull((String)"Wrong data", (Object)builtByFactory.getData());
    }
}

