/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortConfigV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortFeaturesV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortStateV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortStatusMessage;

public class OF10PortStatusMessageFactoryTest {
    private OFDeserializer<PortStatusMessage> statusFactory;

    @Before
    public void startUp() {
        DeserializerRegistryImpl registry = new DeserializerRegistryImpl();
        registry.init();
        this.statusFactory = (OFDeserializer)registry.getDeserializer(new MessageCodeKey(1, 12, PortStatusMessage.class));
    }

    @Test
    public void test() {
        ByteBuf bb = BufferHelper.buildBuffer("00 00 00 00 00 00 00 00 00 10 01 01 05 01 04 02 41 4C 4F 48 41 00 00 00 00 00 00 00 00 00 00 00 00 00 00 15 00 00 00 01 00 00 00 31 00 00 04 42 00 00 03 0C 00 00 08 88");
        PortStatusMessage builtByFactory = BufferHelper.deserialize(this.statusFactory, bb);
        BufferHelper.checkHeaderV10((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong reason", (Object)PortReason.OFPPRADD, (Object)builtByFactory.getReason());
        Assert.assertEquals((String)"Wrong port - port-no", (long)16L, (long)builtByFactory.getPortNo().intValue());
        Assert.assertEquals((String)"Wrong builtByFactory - hw-addr", (Object)new MacAddress("01:01:05:01:04:02"), (Object)builtByFactory.getHwAddr());
        Assert.assertEquals((String)"Wrong builtByFactory - name", (Object)new String("ALOHA"), (Object)builtByFactory.getName());
        Assert.assertEquals((String)"Wrong builtByFactory - config", (Object)new PortConfigV10(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true)), (Object)builtByFactory.getConfigV10());
        Assert.assertEquals((String)"Wrong builtByFactory - state", (Object)new PortStateV10(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)), (Object)builtByFactory.getStateV10());
        Assert.assertEquals((String)"Wrong builtByFactory - curr", (Object)new PortFeaturesV10(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false)), (Object)builtByFactory.getCurrentFeaturesV10());
        Assert.assertEquals((String)"Wrong builtByFactory - advertised", (Object)new PortFeaturesV10(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)), (Object)builtByFactory.getAdvertisedFeaturesV10());
        Assert.assertEquals((String)"Wrong builtByFactory - supbuiltByFactoryed", (Object)new PortFeaturesV10(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false)), (Object)builtByFactory.getSupportedFeaturesV10());
        Assert.assertEquals((String)"Wrong builtByFactory - peer", (Object)new PortFeaturesV10(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true)), (Object)builtByFactory.getPeerFeaturesV10());
    }
}

