/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.RateQueueProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.QueueProperties;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetQueueConfigOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.queue.get.config.reply.Queues;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.queue.property.header.QueueProperty;

public class OF10QueueGetConfigReplyMessageFactoryTest {
    private OFDeserializer<GetQueueConfigOutput> queueFactory;

    @Before
    public void startUp() {
        DeserializerRegistryImpl registry = new DeserializerRegistryImpl();
        registry.init();
        this.queueFactory = (OFDeserializer)registry.getDeserializer(new MessageCodeKey(1, 21, GetQueueConfigOutput.class));
    }

    @Test
    public void test() {
        ByteBuf bb = BufferHelper.buildBuffer("00 01 00 00 00 00 00 00 00 00 00 08 00 10 00 00 00 00 00 08 00 00 00 00 00 00 00 02 00 28 00 00 00 01 00 10 00 00 00 00 00 20 00 00 00 00 00 00 00 01 00 10 00 00 00 00 00 30 00 00 00 00 00 00");
        GetQueueConfigOutput builtByFactory = BufferHelper.deserialize(this.queueFactory, bb);
        BufferHelper.checkHeaderV10((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong port", (long)1L, (long)builtByFactory.getPort().getValue().intValue());
        Assert.assertEquals((String)"Wrong queues size", (long)2L, (long)builtByFactory.getQueues().size());
        Queues queue1 = (Queues)builtByFactory.getQueues().get(0);
        Queues queue2 = (Queues)builtByFactory.getQueues().get(1);
        Assert.assertEquals((String)"Wrong queueId", (long)8L, (long)queue1.getQueueId().getValue().intValue());
        Assert.assertEquals((String)"Wrong queue - # properties", (long)1L, (long)queue1.getQueueProperty().size());
        Assert.assertEquals((String)"Wrong queue - wrong property", (Object)QueueProperties.OFPQTNONE, (Object)((QueueProperty)queue1.getQueueProperty().get(0)).getProperty());
        Assert.assertEquals((String)"Wrong queueId", (long)2L, (long)queue2.getQueueId().getValue().intValue());
        Assert.assertEquals((String)"Wrong queue - # properties", (long)2L, (long)queue2.getQueueProperty().size());
        Assert.assertEquals((String)"Wrong queue - wrong property", (Object)QueueProperties.OFPQTMINRATE, (Object)((QueueProperty)queue2.getQueueProperty().get(0)).getProperty());
        Assert.assertEquals((String)"Wrong queue - wrong property", (Object)QueueProperties.OFPQTMINRATE, (Object)((QueueProperty)queue2.getQueueProperty().get(1)).getProperty());
        RateQueueProperty rate1 = (RateQueueProperty)((QueueProperty)queue2.getQueueProperty().get(0)).getAugmentation(RateQueueProperty.class);
        RateQueueProperty rate2 = (RateQueueProperty)((QueueProperty)queue2.getQueueProperty().get(1)).getAugmentation(RateQueueProperty.class);
        Assert.assertEquals((String)"Wrong queue - wrong property rate", (long)32L, (long)rate1.getRate().intValue());
        Assert.assertEquals((String)"Wrong queue - wrong property rate", (long)48L, (long)rate2.getRate().intValue());
    }
}

