/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import java.math.BigInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.OutputActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetVlanVidCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowWildcardsV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartReplyMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyAggregateCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyDescCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyFlowCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyPortStatsCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyQueueCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyTableCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.aggregate._case.MultipartReplyAggregate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.desc._case.MultipartReplyDesc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.flow._case.MultipartReplyFlow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.flow._case.multipart.reply.flow.FlowStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.stats._case.MultipartReplyPortStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.stats._case.multipart.reply.port.stats.PortStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.queue._case.MultipartReplyQueue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.queue._case.multipart.reply.queue.QueueStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table._case.MultipartReplyTable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table._case.multipart.reply.table.TableStats;

public class OF10StatsReplyMessageFactoryTest {
    private OFDeserializer<MultipartReplyMessage> statsFactory;

    @Before
    public void startUp() {
        DeserializerRegistryImpl registry = new DeserializerRegistryImpl();
        registry.init();
        this.statsFactory = (OFDeserializer)registry.getDeserializer(new MessageCodeKey(1, 17, MultipartReplyMessage.class));
    }

    @Test
    public void testDesc() {
        int DESC_STR_LEN = 256;
        int SERIAL_NUM_LEN = 32;
        ByteBuf bb = BufferHelper.buildBuffer("00 00 00 00");
        String mfrDesc = "Manufacturer description";
        byte[] mfrDescBytes = new byte[256];
        mfrDescBytes = mfrDesc.getBytes();
        bb.writeBytes(mfrDescBytes);
        bb.writeZero(256 - mfrDescBytes.length);
        String hwDesc = "Hardware description";
        byte[] hwDescBytes = new byte[256];
        hwDescBytes = hwDesc.getBytes();
        bb.writeBytes(hwDescBytes);
        bb.writeZero(256 - hwDescBytes.length);
        String swDesc = "Software description";
        byte[] swDescBytes = new byte[256];
        swDescBytes = swDesc.getBytes();
        bb.writeBytes(swDescBytes);
        bb.writeZero(256 - swDescBytes.length);
        String serialNum = "SN0123456789";
        byte[] serialNumBytes = new byte[32];
        serialNumBytes = serialNum.getBytes();
        bb.writeBytes(serialNumBytes);
        bb.writeZero(32 - serialNumBytes.length);
        String dpDesc = "switch3 in room 3120";
        byte[] dpDescBytes = new byte[256];
        dpDescBytes = dpDesc.getBytes();
        bb.writeBytes(dpDescBytes);
        bb.writeZero(256 - dpDescBytes.length);
        MultipartReplyMessage builtByFactory = BufferHelper.deserialize(this.statsFactory, bb);
        BufferHelper.checkHeaderV10((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)0L, (long)builtByFactory.getType().getIntValue());
        Assert.assertEquals((String)"Wrong flag", (Object)false, (Object)builtByFactory.getFlags().isOFPMPFREQMORE());
        MultipartReplyDescCase messageCase = (MultipartReplyDescCase)builtByFactory.getMultipartReplyBody();
        MultipartReplyDesc message = messageCase.getMultipartReplyDesc();
        Assert.assertEquals((String)"Wrong mfrDesc", (Object)"Manufacturer description", (Object)message.getMfrDesc());
        Assert.assertEquals((String)"Wrong hwDesc", (Object)"Hardware description", (Object)message.getHwDesc());
        Assert.assertEquals((String)"Wrong swDesc", (Object)"Software description", (Object)message.getSwDesc());
        Assert.assertEquals((String)"Wrong serialNum", (Object)"SN0123456789", (Object)message.getSerialNum());
        Assert.assertEquals((String)"Wrong dpDesc", (Object)"switch3 in room 3120", (Object)message.getDpDesc());
        Assert.assertTrue((String)"Unread data", (bb.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFlow() {
        ByteBuf bb = BufferHelper.buildBuffer("00 01 00 01 00 68 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 02 00 00 00 03 00 04 00 05 00 06 00 00 00 00 00 00 FF 01 02 03 04 05 06 07 FF 01 02 03 04 05 06 07 FF 00 00 00 00 00 00 20 00 00 00 08 00 01 00 02 00 01 00 08 00 03 00 00");
        MultipartReplyMessage builtByFactory = BufferHelper.deserialize(this.statsFactory, bb);
        BufferHelper.checkHeaderV10((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)1L, (long)builtByFactory.getType().getIntValue());
        Assert.assertEquals((String)"Wrong flag", (Object)true, (Object)builtByFactory.getFlags().isOFPMPFREQMORE());
        MultipartReplyFlowCase messageCase = (MultipartReplyFlowCase)builtByFactory.getMultipartReplyBody();
        MultipartReplyFlow message = messageCase.getMultipartReplyFlow();
        Assert.assertEquals((String)"Wrong tableId", (long)1L, (long)((FlowStats)message.getFlowStats().get(0)).getTableId().intValue());
        Assert.assertEquals((String)"Wrong durationSec", (long)2L, (long)((FlowStats)message.getFlowStats().get(0)).getDurationSec().intValue());
        Assert.assertEquals((String)"Wrong durationNsec", (long)3L, (long)((FlowStats)message.getFlowStats().get(0)).getDurationNsec().intValue());
        Assert.assertEquals((String)"Wrong priority", (long)4L, (long)((FlowStats)message.getFlowStats().get(0)).getPriority().intValue());
        Assert.assertEquals((String)"Wrong idleTimeOut", (long)5L, (long)((FlowStats)message.getFlowStats().get(0)).getIdleTimeout().intValue());
        Assert.assertEquals((String)"Wrong hardTimeOut", (long)6L, (long)((FlowStats)message.getFlowStats().get(0)).getHardTimeout().intValue());
        Assert.assertEquals((String)"Wrong cookie", (Object)new BigInteger(1, new byte[]{-1, 1, 2, 3, 4, 5, 6, 7}), (Object)((FlowStats)message.getFlowStats().get(0)).getCookie());
        Assert.assertEquals((String)"Wrong packetCount", (Object)new BigInteger(1, new byte[]{-1, 1, 2, 3, 4, 5, 6, 7}), (Object)((FlowStats)message.getFlowStats().get(0)).getPacketCount());
        Assert.assertEquals((String)"Wrong byteCount", (Object)new BigInteger(1, new byte[]{-1, 0, 0, 0, 0, 0, 0, 32}), (Object)((FlowStats)message.getFlowStats().get(0)).getByteCount());
        Action action1 = (Action)((FlowStats)message.getFlowStats().get(0)).getAction().get(0);
        Assert.assertTrue((String)"Wrong action type", (boolean)(action1.getActionChoice() instanceof OutputActionCase));
        Assert.assertEquals((String)"Wrong action port", (long)1L, (long)((OutputActionCase)action1.getActionChoice()).getOutputAction().getPort().getValue().intValue());
        Assert.assertEquals((String)"Wrong action port", (long)2L, (long)((OutputActionCase)action1.getActionChoice()).getOutputAction().getMaxLength().intValue());
        Action action2 = (Action)((FlowStats)message.getFlowStats().get(0)).getAction().get(1);
        Assert.assertTrue((String)"Wrong action type", (boolean)(action2.getActionChoice() instanceof SetVlanVidCase));
        Assert.assertEquals((String)"Wrong action port", (long)3L, (long)((SetVlanVidCase)action2.getActionChoice()).getSetVlanVidAction().getVlanVid().intValue());
        Assert.assertTrue((String)"Unread data", (bb.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAggregate() {
        ByteBuf bb = BufferHelper.buildBuffer("00 02 00 01 FF 01 02 03 04 05 06 07 FF 00 00 00 00 00 00 20 00 00 00 30 00 00 00 00");
        MultipartReplyMessage builtByFactory = BufferHelper.deserialize(this.statsFactory, bb);
        BufferHelper.checkHeaderV10((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)2L, (long)builtByFactory.getType().getIntValue());
        Assert.assertEquals((String)"Wrong flag", (Object)true, (Object)builtByFactory.getFlags().isOFPMPFREQMORE());
        MultipartReplyAggregateCase messageCase = (MultipartReplyAggregateCase)builtByFactory.getMultipartReplyBody();
        MultipartReplyAggregate message = messageCase.getMultipartReplyAggregate();
        Assert.assertEquals((String)"Wrong packet-count", (Object)new BigInteger(1, new byte[]{-1, 1, 2, 3, 4, 5, 6, 7}), (Object)message.getPacketCount());
        Assert.assertEquals((String)"Wrong byte-count", (Object)new BigInteger(1, new byte[]{-1, 0, 0, 0, 0, 0, 0, 32}), (Object)message.getByteCount());
        Assert.assertEquals((String)"Wrong flow-count", (long)48L, (long)message.getFlowCount().intValue());
        Assert.assertTrue((String)"Unread data", (bb.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTable() {
        ByteBuf bb = BufferHelper.buildBuffer("00 03 00 01 08 00 00 00 4A 41 4D 45 53 20 42 4F 4E 44 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 30 00 00 00 10 FF 01 01 01 01 01 01 01 FF 01 01 01 01 01 01 00");
        MultipartReplyMessage builtByFactory = BufferHelper.deserialize(this.statsFactory, bb);
        BufferHelper.checkHeaderV10((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)3L, (long)builtByFactory.getType().getIntValue());
        Assert.assertEquals((String)"Wrong flag", (Object)true, (Object)builtByFactory.getFlags().isOFPMPFREQMORE());
        MultipartReplyTableCase messageCase = (MultipartReplyTableCase)builtByFactory.getMultipartReplyBody();
        MultipartReplyTable message = messageCase.getMultipartReplyTable();
        Assert.assertEquals((String)"Wrong tableId", (long)8L, (long)((TableStats)message.getTableStats().get(0)).getTableId().intValue());
        Assert.assertEquals((String)"Wrong name", (Object)"JAMES BOND", (Object)((TableStats)message.getTableStats().get(0)).getName());
        Assert.assertEquals((String)"Wrong wildcards", (Object)new FlowWildcardsV10(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false)), (Object)((TableStats)message.getTableStats().get(0)).getWildcards());
        Assert.assertEquals((String)"Wrong src-mask", (long)32L, (long)((TableStats)message.getTableStats().get(0)).getNwSrcMask().intValue());
        Assert.assertEquals((String)"Wrong dst-mask", (long)32L, (long)((TableStats)message.getTableStats().get(0)).getNwDstMask().intValue());
        Assert.assertEquals((String)"Wrong max-entries", (long)48L, (long)((TableStats)message.getTableStats().get(0)).getMaxEntries());
        Assert.assertEquals((String)"Wrong activeCount", (long)16L, (long)((TableStats)message.getTableStats().get(0)).getActiveCount());
        Assert.assertEquals((String)"Wrong lookupCount", (Object)new BigInteger(1, new byte[]{-1, 1, 1, 1, 1, 1, 1, 1}), (Object)((TableStats)message.getTableStats().get(0)).getLookupCount());
        Assert.assertEquals((String)"Wrong matchedCount", (Object)new BigInteger(1, new byte[]{-1, 1, 1, 1, 1, 1, 1, 0}), (Object)((TableStats)message.getTableStats().get(0)).getMatchedCount());
        Assert.assertTrue((String)"Unread data", (bb.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPort() {
        ByteBuf bb = BufferHelper.buildBuffer("00 04 00 01 00 FF 00 00 00 00 00 00 FF 01 01 01 01 01 01 01 FF 02 02 02 02 02 02 02 FF 02 03 02 03 02 03 02 FF 02 03 02 03 02 03 02 FF 02 03 02 03 02 03 02 FF 02 03 02 03 02 03 02 FF 02 03 02 03 02 03 02 FF 02 03 02 03 02 03 02 FF 02 03 02 03 02 03 02 FF 02 03 02 03 02 03 02 FF 02 03 02 03 02 03 02 FF 02 03 02 03 02 03 02");
        MultipartReplyMessage builtByFactory = BufferHelper.deserialize(this.statsFactory, bb);
        BufferHelper.checkHeaderV10((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)4L, (long)builtByFactory.getType().getIntValue());
        Assert.assertEquals((String)"Wrong flag", (Object)true, (Object)builtByFactory.getFlags().isOFPMPFREQMORE());
        MultipartReplyPortStatsCase messageCase = (MultipartReplyPortStatsCase)builtByFactory.getMultipartReplyBody();
        MultipartReplyPortStats message = messageCase.getMultipartReplyPortStats();
        Assert.assertEquals((String)"Wrong portNo", (long)255L, (long)((PortStats)message.getPortStats().get(0)).getPortNo().intValue());
        Assert.assertEquals((String)"Wrong rxPackets", (Object)new BigInteger(1, new byte[]{-1, 1, 1, 1, 1, 1, 1, 1}), (Object)((PortStats)message.getPortStats().get(0)).getRxPackets());
        Assert.assertEquals((String)"Wrong txPackets", (Object)new BigInteger(1, new byte[]{-1, 2, 2, 2, 2, 2, 2, 2}), (Object)((PortStats)message.getPortStats().get(0)).getTxPackets());
        Assert.assertEquals((String)"Wrong rxBytes", (Object)new BigInteger(1, new byte[]{-1, 2, 3, 2, 3, 2, 3, 2}), (Object)((PortStats)message.getPortStats().get(0)).getRxBytes());
        Assert.assertEquals((String)"Wrong txBytes", (Object)new BigInteger(1, new byte[]{-1, 2, 3, 2, 3, 2, 3, 2}), (Object)((PortStats)message.getPortStats().get(0)).getTxBytes());
        Assert.assertEquals((String)"Wrong rxDropped", (Object)new BigInteger(1, new byte[]{-1, 2, 3, 2, 3, 2, 3, 2}), (Object)((PortStats)message.getPortStats().get(0)).getRxDropped());
        Assert.assertEquals((String)"Wrong txDropped", (Object)new BigInteger(1, new byte[]{-1, 2, 3, 2, 3, 2, 3, 2}), (Object)((PortStats)message.getPortStats().get(0)).getTxDropped());
        Assert.assertEquals((String)"Wrong rxErrors", (Object)new BigInteger(1, new byte[]{-1, 2, 3, 2, 3, 2, 3, 2}), (Object)((PortStats)message.getPortStats().get(0)).getRxErrors());
        Assert.assertEquals((String)"Wrong txErrors", (Object)new BigInteger(1, new byte[]{-1, 2, 3, 2, 3, 2, 3, 2}), (Object)((PortStats)message.getPortStats().get(0)).getTxErrors());
        Assert.assertEquals((String)"Wrong rxFrameErr", (Object)new BigInteger(1, new byte[]{-1, 2, 3, 2, 3, 2, 3, 2}), (Object)((PortStats)message.getPortStats().get(0)).getRxFrameErr());
        Assert.assertEquals((String)"Wrong rxOverErr", (Object)new BigInteger(1, new byte[]{-1, 2, 3, 2, 3, 2, 3, 2}), (Object)((PortStats)message.getPortStats().get(0)).getRxOverErr());
        Assert.assertEquals((String)"Wrong rxCrcErr", (Object)new BigInteger(1, new byte[]{-1, 2, 3, 2, 3, 2, 3, 2}), (Object)((PortStats)message.getPortStats().get(0)).getRxCrcErr());
        Assert.assertEquals((String)"Wrong collisions", (Object)new BigInteger(1, new byte[]{-1, 2, 3, 2, 3, 2, 3, 2}), (Object)((PortStats)message.getPortStats().get(0)).getCollisions());
        Assert.assertTrue((String)"Unread data", (bb.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testQueue() {
        ByteBuf bb = BufferHelper.buildBuffer("00 05 00 00 00 FF 00 00 00 00 00 10 FF 02 03 02 03 02 03 02 FF 02 02 02 02 02 02 02 FF 02 03 02 03 02 03 02");
        MultipartReplyMessage builtByFactory = BufferHelper.deserialize(this.statsFactory, bb);
        BufferHelper.checkHeaderV10((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)5L, (long)builtByFactory.getType().getIntValue());
        Assert.assertEquals((String)"Wrong flag", (Object)false, (Object)builtByFactory.getFlags().isOFPMPFREQMORE());
        MultipartReplyQueueCase messageCase = (MultipartReplyQueueCase)builtByFactory.getMultipartReplyBody();
        MultipartReplyQueue message = messageCase.getMultipartReplyQueue();
        Assert.assertEquals((String)"Wrong portNo", (long)255L, (long)((QueueStats)message.getQueueStats().get(0)).getPortNo().intValue());
        Assert.assertEquals((String)"Wrong queueId", (long)16L, (long)((QueueStats)message.getQueueStats().get(0)).getQueueId().intValue());
        Assert.assertEquals((String)"Wrong txBytes", (Object)new BigInteger(1, new byte[]{-1, 2, 3, 2, 3, 2, 3, 2}), (Object)((QueueStats)message.getQueueStats().get(0)).getTxBytes());
        Assert.assertEquals((String)"Wrong txPackets", (Object)new BigInteger(1, new byte[]{-1, 2, 2, 2, 2, 2, 2, 2}), (Object)((QueueStats)message.getQueueStats().get(0)).getTxPackets());
        Assert.assertEquals((String)"Wrong txErrors", (Object)new BigInteger(1, new byte[]{-1, 2, 3, 2, 3, 2, 3, 2}), (Object)((QueueStats)message.getQueueStats().get(0)).getTxErrors());
        Assert.assertTrue((String)"Unread data", (bb.readableBytes() == 0 ? 1 : 0) != 0);
    }
}

