/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortModInput;

public class PortModInputMessageFactoryTest {
    private OFDeserializer<PortModInput> factory;

    @Before
    public void startUp() throws Exception {
        DeserializerRegistryImpl desRegistry = new DeserializerRegistryImpl();
        desRegistry.init();
        this.factory = (OFDeserializer)desRegistry.getDeserializer(new MessageCodeKey(4, 16, PortModInput.class));
    }

    @Test
    public void test() throws Exception {
        ByteBuf bb = BufferHelper.buildBuffer("00 00 00 09 00 00 00 00 08 00 27 00 b0 eb 00 00 00 00 00 24 00 00 00 41 00 00 01 10 00 00 00 00");
        PortModInput deserializedMessage = BufferHelper.deserialize(this.factory, bb);
        BufferHelper.checkHeaderV13((OfHeader)deserializedMessage);
        Assert.assertEquals((String)"Wrong port", (Object)new PortNumber(Long.valueOf(9L)), (Object)deserializedMessage.getPortNo());
        Assert.assertEquals((String)"Wrong hwAddr", (Object)new MacAddress("08:00:27:00:b0:eb"), (Object)deserializedMessage.getHwAddress());
        Assert.assertEquals((String)"Wrong config", (Object)new PortConfig(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)), (Object)deserializedMessage.getConfig());
        Assert.assertEquals((String)"Wrong mask", (Object)new PortConfig(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true)), (Object)deserializedMessage.getMask());
        Assert.assertEquals((String)"Wrong advertise", (Object)new PortFeatures(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false)), (Object)deserializedMessage.getAdvertise());
    }
}

