/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortState;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortStatusMessage;

public class PortStatusMessageFactoryTest {
    private OFDeserializer<PortStatusMessage> statusFactory;

    @Before
    public void startUp() {
        DeserializerRegistryImpl registry = new DeserializerRegistryImpl();
        registry.init();
        this.statusFactory = (OFDeserializer)registry.getDeserializer(new MessageCodeKey(4, 12, PortStatusMessage.class));
    }

    @Test
    public void test() {
        ByteBuf bb = BufferHelper.buildBuffer("01 00 00 00 00 00 00 00 00 01 02 03 00 00 00 00 08 00 27 00 B0 EB 00 00 73 31 2d 65 74 68 31 00 00 00 00 00 00 00 00 00 00 00 00 41 00 00 00 05 00 00 00 81 00 00 00 A1 00 00 00 B1 00 00 00 81 00 00 00 81 00 00 00 80");
        PortStatusMessage builtByFactory = BufferHelper.deserialize(this.statusFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong reason", (long)1L, (long)builtByFactory.getReason().getIntValue());
        Assert.assertEquals((String)"Wrong portNumber", (long)66051L, (long)builtByFactory.getPortNo());
        Assert.assertEquals((String)"Wrong macAddress", (Object)new MacAddress("08:00:27:00:b0:eb"), (Object)builtByFactory.getHwAddr());
        Assert.assertEquals((String)"Wrong name", (Object)"s1-eth1", (Object)builtByFactory.getName());
        Assert.assertEquals((String)"Wrong portConfig", (Object)new PortConfig(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true)), (Object)builtByFactory.getConfig());
        Assert.assertEquals((String)"Wrong portState", (Object)new PortState(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true)), (Object)builtByFactory.getState());
        Assert.assertEquals((String)"Wrong currentFeatures", (Object)new PortFeatures(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false)), (Object)builtByFactory.getCurrentFeatures());
        Assert.assertEquals((String)"Wrong advertisedFeatures", (Object)new PortFeatures(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false)), (Object)builtByFactory.getAdvertisedFeatures());
        Assert.assertEquals((String)"Wrong supportedFeatures", (Object)new PortFeatures(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false)), (Object)builtByFactory.getSupportedFeatures());
        Assert.assertEquals((String)"Wrong peerFeatures", (Object)new PortFeatures(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false)), (Object)builtByFactory.getPeerFeatures());
        Assert.assertEquals((String)"Wrong currSpeed", (long)129L, (long)builtByFactory.getCurrSpeed());
        Assert.assertEquals((String)"Wrong maxSpeed", (long)128L, (long)builtByFactory.getMaxSpeed());
    }

    @Test
    public void testWithDifferentBitmaps() {
        ByteBuf bb = BufferHelper.buildBuffer("01 00 00 00 00 00 00 00 00 01 02 03 00 00 00 00 08 00 27 00 B0 EB 00 00 73 31 2d 65 74 68 31 00 00 00 00 00 00 00 00 00 00 00 00 24 00 00 00 02 00 00 00 81 00 00 00 A1 00 00 FF FF 00 00 00 00 00 00 00 81 00 00 00 80");
        PortStatusMessage message = BufferHelper.deserialize(this.statusFactory, bb);
        Assert.assertEquals((String)"Wrong portConfig", (Object)new PortConfig(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)), (Object)message.getConfig());
        Assert.assertEquals((String)"Wrong portState", (Object)new PortState(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false)), (Object)message.getState());
        Assert.assertEquals((String)"Wrong supportedFeatures", (Object)new PortFeatures(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true)), (Object)message.getSupportedFeatures());
        Assert.assertEquals((String)"Wrong peerFeatures", (Object)new PortFeatures(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false)), (Object)message.getPeerFeatures());
    }
}

