/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.RateQueueProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.RateQueuePropertyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.QueueId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.QueueProperties;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetQueueConfigOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.queue.get.config.reply.Queues;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.queue.get.config.reply.QueuesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.queue.property.header.QueueProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.queue.property.header.QueuePropertyBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class QueueGetConfigReplyMessageFactoryMultiTest {
    private OFDeserializer<GetQueueConfigOutput> queueFactory;

    @Before
    public void startUp() {
        DeserializerRegistryImpl registry = new DeserializerRegistryImpl();
        registry.init();
        this.queueFactory = (OFDeserializer)registry.getDeserializer(new MessageCodeKey(4, 23, GetQueueConfigOutput.class));
    }

    @Test
    public void test() {
        ByteBuf bb = BufferHelper.buildBuffer("00 01 02 03 00 00 00 00 00 00 00 01 00 00 00 01 00 20 00 00 00 00 00 00 00 02 00 10 00 00 00 00 00 05 00 00 00 00 00 00 00 00 00 02 00 00 00 02 00 20 00 00 00 00 00 00 00 02 00 10 00 00 00 00 00 05 00 00 00 00 00 00");
        GetQueueConfigOutput builtByFactory = BufferHelper.deserialize(this.queueFactory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong port", (long)66051L, (long)builtByFactory.getPort().getValue());
        Assert.assertEquals((String)"Wrong queues", QueueGetConfigReplyMessageFactoryMultiTest.createQueuesList(), (Object)builtByFactory.getQueues());
    }

    private static List<Queues> createQueuesList() {
        ArrayList<Queues> queuesList = new ArrayList<Queues>();
        for (int i = 1; i < 3; ++i) {
            QueuesBuilder qb = new QueuesBuilder();
            qb.setQueueId(new QueueId(Long.valueOf(i)));
            qb.setPort(new PortNumber(Long.valueOf(i)));
            qb.setQueueProperty(QueueGetConfigReplyMessageFactoryMultiTest.createPropertiesList());
            queuesList.add(qb.build());
        }
        return queuesList;
    }

    private static List<QueueProperty> createPropertiesList() {
        ArrayList<QueueProperty> propertiesList = new ArrayList<QueueProperty>();
        QueuePropertyBuilder pb = new QueuePropertyBuilder();
        pb.setProperty(QueueProperties.forValue((int)2));
        RateQueuePropertyBuilder rateBuilder = new RateQueuePropertyBuilder();
        rateBuilder.setRate(Integer.valueOf(5));
        pb.addAugmentation(RateQueueProperty.class, (Augmentation)rateBuilder.build());
        propertiesList.add(pb.build());
        return propertiesList;
    }
}

