/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import java.math.BigInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ControllerRole;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.RoleRequestInput;

public class RoleRequestInputMessageFactoryTest {
    private OFDeserializer<RoleRequestInput> factory;

    @Before
    public void startUp() {
        DeserializerRegistryImpl desRegistry = new DeserializerRegistryImpl();
        desRegistry.init();
        this.factory = (OFDeserializer)desRegistry.getDeserializer(new MessageCodeKey(4, 24, RoleRequestInput.class));
    }

    @Test
    public void test() {
        ByteBuf bb = BufferHelper.buildBuffer("00 00 00 02 00 00 00 00 ff 01 01 01 01 01 01 01");
        RoleRequestInput deserializedMessage = BufferHelper.deserialize(this.factory, bb);
        BufferHelper.checkHeaderV13((OfHeader)deserializedMessage);
        Assert.assertEquals((String)"Wrong role", (Object)ControllerRole.forValue((int)2), (Object)deserializedMessage.getRole());
        byte[] generationId = new byte[]{-1, 1, 1, 1, 1, 1, 1, 1};
        Assert.assertEquals((String)"Wrong generation Id", (Object)new BigInteger(1, generationId), (Object)deserializedMessage.getGenerationId());
    }
}

