/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowRemovedReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PacketInReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.SetAsyncInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.async.body.grouping.FlowRemovedMask;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.async.body.grouping.FlowRemovedMaskBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.async.body.grouping.PacketInMask;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.async.body.grouping.PacketInMaskBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.async.body.grouping.PortStatusMask;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.async.body.grouping.PortStatusMaskBuilder;

public class SetAsyncInputMessageFactoryTest {
    private OFDeserializer<SetAsyncInput> factory;

    @Before
    public void startUp() {
        DeserializerRegistryImpl desRegistry = new DeserializerRegistryImpl();
        desRegistry.init();
        this.factory = (OFDeserializer)desRegistry.getDeserializer(new MessageCodeKey(4, 28, SetAsyncInput.class));
    }

    @Test
    public void test() {
        ByteBuf bb = BufferHelper.buildBuffer("00 00 00 07 00 00 00 00 00 00 00 07 00 00 00 00 00 00 00 0f 00 00 00 00");
        SetAsyncInput deserializedMessage = BufferHelper.deserialize(this.factory, bb);
        BufferHelper.checkHeaderV13((OfHeader)deserializedMessage);
        Assert.assertEquals((String)"Wrong packet in mask ", (Object)SetAsyncInputMessageFactoryTest.createPacketInMask().get(0), deserializedMessage.getPacketInMask().get(0));
        Assert.assertEquals((String)"Wrong packet in mask ", (Object)SetAsyncInputMessageFactoryTest.createPacketInMask().get(1), deserializedMessage.getPacketInMask().get(1));
        Assert.assertEquals((String)"Wrong port status mask ", (Object)SetAsyncInputMessageFactoryTest.createPortStatusMask().get(0), deserializedMessage.getPortStatusMask().get(0));
        Assert.assertEquals((String)"Wrong port status mask ", (Object)SetAsyncInputMessageFactoryTest.createPortStatusMask().get(1), deserializedMessage.getPortStatusMask().get(1));
        Assert.assertEquals((String)"Wrong flow removed mask ", (Object)SetAsyncInputMessageFactoryTest.createFlowRemowedMask().get(0), deserializedMessage.getFlowRemovedMask().get(0));
        Assert.assertEquals((String)"Wrong flow removed mask ", (Object)SetAsyncInputMessageFactoryTest.createFlowRemowedMask().get(1), deserializedMessage.getFlowRemovedMask().get(1));
    }

    private static List<PacketInMask> createPacketInMask() {
        ArrayList<PacketInMask> masks = new ArrayList<PacketInMask>();
        PacketInMaskBuilder builder = new PacketInMaskBuilder();
        ArrayList<PacketInReason> packetInReasonList = new ArrayList<PacketInReason>();
        packetInReasonList.add(PacketInReason.OFPRNOMATCH);
        packetInReasonList.add(PacketInReason.OFPRACTION);
        packetInReasonList.add(PacketInReason.OFPRINVALIDTTL);
        builder.setMask(packetInReasonList);
        masks.add(builder.build());
        builder = new PacketInMaskBuilder();
        packetInReasonList = new ArrayList();
        builder.setMask(packetInReasonList);
        masks.add(builder.build());
        return masks;
    }

    private static List<PortStatusMask> createPortStatusMask() {
        ArrayList<PortStatusMask> masks = new ArrayList<PortStatusMask>();
        PortStatusMaskBuilder builder = new PortStatusMaskBuilder();
        ArrayList<PortReason> portReasonList = new ArrayList<PortReason>();
        portReasonList.add(PortReason.OFPPRADD);
        portReasonList.add(PortReason.OFPPRDELETE);
        portReasonList.add(PortReason.OFPPRMODIFY);
        builder.setMask(portReasonList);
        masks.add(builder.build());
        builder = new PortStatusMaskBuilder();
        portReasonList = new ArrayList();
        builder.setMask(portReasonList);
        masks.add(builder.build());
        return masks;
    }

    private static List<FlowRemovedMask> createFlowRemowedMask() {
        ArrayList<FlowRemovedMask> masks = new ArrayList<FlowRemovedMask>();
        FlowRemovedMaskBuilder builder = new FlowRemovedMaskBuilder();
        ArrayList<FlowRemovedReason> flowRemovedReasonList = new ArrayList<FlowRemovedReason>();
        flowRemovedReasonList.add(FlowRemovedReason.OFPRRIDLETIMEOUT);
        flowRemovedReasonList.add(FlowRemovedReason.OFPRRHARDTIMEOUT);
        flowRemovedReasonList.add(FlowRemovedReason.OFPRRDELETE);
        flowRemovedReasonList.add(FlowRemovedReason.OFPRRGROUPDELETE);
        builder.setMask(flowRemovedReasonList);
        masks.add(builder.build());
        builder = new FlowRemovedMaskBuilder();
        flowRemovedReasonList = new ArrayList();
        builder.setMask(flowRemovedReasonList);
        masks.add(builder.build());
        return masks;
    }
}

