/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistry;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.deserialization.factories.ExperimenterMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.deserialization.factories.VendorMessageFactory;
import org.opendaylight.openflowjava.util.ByteBufUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class VendorMessageFactoryTest {
    @Mock
    DeserializerRegistry registry;
    @Mock
    ExperimenterMessageFactory deserializer;

    @Test
    public void test() {
        Mockito.when((Object)this.registry.getDeserializer((MessageCodeKey)Matchers.any())).thenReturn((Object)this.deserializer);
        ByteBuf buffer = ByteBufUtils.hexStringToByteBuf((String)"01 02 03 04 FF FF FF FF 80 00 00 00");
        VendorMessageFactory factory = new VendorMessageFactory();
        factory.injectDeserializerRegistry(this.registry);
        factory.deserialize(buffer);
        ((ExperimenterMessageFactory)Mockito.verify((Object)this.deserializer, (VerificationMode)Mockito.times((int)1))).deserialize(buffer);
        Assert.assertEquals((String)"Buffer index modified", (long)4L, (long)buffer.readableBytes());
    }
}

