/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories.multipart;

import io.netty.buffer.ByteBuf;
import java.math.BigInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DeserializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowModFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OxmMatchType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartReplyMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyFlowCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.flow._case.MultipartReplyFlow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.flow._case.multipart.reply.flow.FlowStats;

public class MultipartReplyFlowTest {
    private OFDeserializer<MultipartReplyMessage> factory;

    @Before
    public void startUp() {
        DeserializerRegistryImpl registry = new DeserializerRegistryImpl();
        registry.init();
        this.factory = (OFDeserializer)registry.getDeserializer(new MessageCodeKey(4, 19, MultipartReplyMessage.class));
    }

    @Test
    public void testEmptyMultipartReplyFlowBody() {
        ByteBuf bb = BufferHelper.buildBuffer("00 01 00 01 00 00 00 00");
        MultipartReplyMessage builtByFactory = BufferHelper.deserialize(this.factory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)1L, (long)builtByFactory.getType().getIntValue());
        Assert.assertEquals((String)"Wrong flag", (Object)true, (Object)builtByFactory.getFlags().isOFPMPFREQMORE());
        MultipartReplyFlowCase messageCase = (MultipartReplyFlowCase)builtByFactory.getMultipartReplyBody();
        MultipartReplyFlow message = messageCase.getMultipartReplyFlow();
        Assert.assertEquals((String)"Wrong flow stats size", (long)0L, (long)message.getFlowStats().size());
    }

    @Test
    public void testMultipartReplyFlowBody() {
        ByteBuf bb = BufferHelper.buildBuffer("00 01 00 01 00 00 00 00 00 48 08 00 00 00 00 09 00 00 00 07 00 0C 00 0E 00 0F 00 1F 00 00 00 00 FF 01 01 01 01 01 01 01 EF 01 01 01 01 01 01 01 7F 01 01 01 01 01 01 01 00 01 00 04 00 00 00 00 00 01 00 08 06 00 00 00 00 01 00 08 06 00 00 00 00 48 08 00 00 00 00 09 00 00 00 07 00 0C 00 0E 00 0F 00 00 00 00 00 00 FF 01 01 01 01 01 01 01 EF 01 01 01 01 01 01 01 7F 01 01 01 01 01 01 01 00 01 00 04 00 00 00 00 00 01 00 08 06 00 00 00 00 01 00 08 06 00 00 00");
        MultipartReplyMessage builtByFactory = BufferHelper.deserialize(this.factory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)1L, (long)builtByFactory.getType().getIntValue());
        Assert.assertEquals((String)"Wrong flag", (Object)true, (Object)builtByFactory.getFlags().isOFPMPFREQMORE());
        MultipartReplyFlowCase messageCase = (MultipartReplyFlowCase)builtByFactory.getMultipartReplyBody();
        MultipartReplyFlow message = messageCase.getMultipartReplyFlow();
        Assert.assertEquals((String)"Wrong flow stats size", (long)2L, (long)message.getFlowStats().size());
        FlowStats flowStats1 = (FlowStats)message.getFlowStats().get(0);
        Assert.assertEquals((String)"Wrong tableId", (long)8L, (long)flowStats1.getTableId().intValue());
        Assert.assertEquals((String)"Wrong durationSec", (long)9L, (long)flowStats1.getDurationSec().intValue());
        Assert.assertEquals((String)"Wrong durationNsec", (long)7L, (long)flowStats1.getDurationNsec().intValue());
        Assert.assertEquals((String)"Wrong priority", (long)12L, (long)flowStats1.getPriority().intValue());
        Assert.assertEquals((String)"Wrong idleTimeOut", (long)14L, (long)flowStats1.getIdleTimeout().intValue());
        Assert.assertEquals((String)"Wrong hardTimeOut", (long)15L, (long)flowStats1.getHardTimeout().intValue());
        Assert.assertEquals((String)"Wrong flags", (Object)new FlowModFlags(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true)), (Object)flowStats1.getFlags());
        Assert.assertEquals((String)"Wrong cookie", (Object)new BigInteger(1, new byte[]{-1, 1, 1, 1, 1, 1, 1, 1}), (Object)flowStats1.getCookie());
        Assert.assertEquals((String)"Wrong packetCount", (Object)new BigInteger(1, new byte[]{-17, 1, 1, 1, 1, 1, 1, 1}), (Object)flowStats1.getPacketCount());
        Assert.assertEquals((String)"Wrong byteCount", (Object)new BigInteger(1, new byte[]{127, 1, 1, 1, 1, 1, 1, 1}), (Object)flowStats1.getByteCount());
        Assert.assertEquals((String)"Wrong match type", OxmMatchType.class, (Object)flowStats1.getMatch().getType());
        flowStats1 = (FlowStats)message.getFlowStats().get(1);
        Assert.assertEquals((String)"Wrong tableId", (long)8L, (long)flowStats1.getTableId().intValue());
        Assert.assertEquals((String)"Wrong durationSec", (long)9L, (long)flowStats1.getDurationSec().intValue());
        Assert.assertEquals((String)"Wrong durationNsec", (long)7L, (long)flowStats1.getDurationNsec().intValue());
        Assert.assertEquals((String)"Wrong priority", (long)12L, (long)flowStats1.getPriority().intValue());
        Assert.assertEquals((String)"Wrong idleTimeOut", (long)14L, (long)flowStats1.getIdleTimeout().intValue());
        Assert.assertEquals((String)"Wrong hardTimeOut", (long)15L, (long)flowStats1.getHardTimeout().intValue());
        Assert.assertEquals((String)"Wrong flags", (Object)new FlowModFlags(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false)), (Object)flowStats1.getFlags());
        Assert.assertEquals((String)"Wrong cookie", (Object)new BigInteger(1, new byte[]{-1, 1, 1, 1, 1, 1, 1, 1}), (Object)flowStats1.getCookie());
        Assert.assertEquals((String)"Wrong packetCount", (Object)new BigInteger(1, new byte[]{-17, 1, 1, 1, 1, 1, 1, 1}), (Object)flowStats1.getPacketCount());
        Assert.assertEquals((String)"Wrong byteCount", (Object)new BigInteger(1, new byte[]{127, 1, 1, 1, 1, 1, 1, 1}), (Object)flowStats1.getByteCount());
        Assert.assertEquals((String)"Wrong match type", OxmMatchType.class, (Object)flowStats1.getMatch().getType());
    }
}

