/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories.multipart;

import io.netty.buffer.ByteBuf;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.impl.deserialization.factories.MultipartReplyMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ActionType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupTypes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartReplyMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyGroupFeaturesCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group.features._case.MultipartReplyGroupFeatures;

public class MultipartReplyGroupFeaturesTest {
    private MultipartReplyMessageFactory factory = new MultipartReplyMessageFactory();

    @Test
    public void testMultipartReplyGroupFeatures() {
        ByteBuf bb = BufferHelper.buildBuffer("00 08 00 01 00 00 00 00 00 00 00 0F 00 00 00 0F 00 00 00 01 00 00 00 02 00 00 00 03 00 00 00 04 0F FF 98 01 00 00 00 00 00 00 00 00 00 00 00 00");
        MultipartReplyMessage builtByFactory = (MultipartReplyMessage)BufferHelper.deserialize(this.factory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)8L, (long)builtByFactory.getType().getIntValue());
        Assert.assertEquals((String)"Wrong flag", (Object)true, (Object)builtByFactory.getFlags().isOFPMPFREQMORE());
        MultipartReplyGroupFeaturesCase messageCase = (MultipartReplyGroupFeaturesCase)builtByFactory.getMultipartReplyBody();
        MultipartReplyGroupFeatures message = messageCase.getMultipartReplyGroupFeatures();
        Assert.assertEquals((String)"Wrong group types", (Object)new GroupTypes(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true)), (Object)message.getTypes());
        Assert.assertEquals((String)"Wrong capabilities", (Object)new GroupCapabilities(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true)), (Object)message.getCapabilities());
        Assert.assertEquals((String)"Wrong max groups", (long)1L, (long)((Long)message.getMaxGroups().get(0)).intValue());
        Assert.assertEquals((String)"Wrong max groups", (long)2L, (long)((Long)message.getMaxGroups().get(1)).intValue());
        Assert.assertEquals((String)"Wrong max groups", (long)3L, (long)((Long)message.getMaxGroups().get(2)).intValue());
        Assert.assertEquals((String)"Wrong max groups", (long)4L, (long)((Long)message.getMaxGroups().get(3)).intValue());
        Assert.assertEquals((String)"Wrong actions bitmap", (Object)new ActionType(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true)), message.getActionsBitmap().get(0));
        Assert.assertEquals((String)"Wrong actions bitmap", (Object)new ActionType(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false)), message.getActionsBitmap().get(1));
        Assert.assertEquals((String)"Wrong actions bitmap", (Object)new ActionType(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false)), message.getActionsBitmap().get(2));
        Assert.assertEquals((String)"Wrong actions bitmap", (Object)new ActionType(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false)), message.getActionsBitmap().get(3));
    }

    @Test
    public void testMultipartReplyGroupFeatures2() {
        ByteBuf bb = BufferHelper.buildBuffer("00 08 00 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 01 00 00 00 02 00 00 00 03 00 00 00 04 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00");
        MultipartReplyMessage builtByFactory = (MultipartReplyMessage)BufferHelper.deserialize(this.factory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)8L, (long)builtByFactory.getType().getIntValue());
        Assert.assertEquals((String)"Wrong flag", (Object)true, (Object)builtByFactory.getFlags().isOFPMPFREQMORE());
        MultipartReplyGroupFeaturesCase messageCase = (MultipartReplyGroupFeaturesCase)builtByFactory.getMultipartReplyBody();
        MultipartReplyGroupFeatures message = messageCase.getMultipartReplyGroupFeatures();
        Assert.assertEquals((String)"Wrong group types", (Object)new GroupTypes(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false)), (Object)message.getTypes());
        Assert.assertEquals((String)"Wrong capabilities", (Object)new GroupCapabilities(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false)), (Object)message.getCapabilities());
    }
}

