/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories.multipart;

import io.netty.buffer.ByteBuf;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.impl.deserialization.factories.MultipartReplyMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterBandTypeBitmap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartReplyMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyMeterFeaturesCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.features._case.MultipartReplyMeterFeatures;

public class MultipartReplyMeterFeaturesTest {
    private MultipartReplyMessageFactory factory = new MultipartReplyMessageFactory();

    @Test
    public void testMultipartReplyMeterFeatures() {
        ByteBuf bb = BufferHelper.buildBuffer("00 0B 00 01 00 00 00 00 00 00 00 0A 00 00 00 06 00 00 00 0F 07 08 00 00");
        MultipartReplyMessage builtByFactory = (MultipartReplyMessage)BufferHelper.deserialize(this.factory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)11L, (long)builtByFactory.getType().getIntValue());
        Assert.assertEquals((String)"Wrong flag", (Object)true, (Object)builtByFactory.getFlags().isOFPMPFREQMORE());
        MultipartReplyMeterFeaturesCase messageCase = (MultipartReplyMeterFeaturesCase)builtByFactory.getMultipartReplyBody();
        MultipartReplyMeterFeatures message = messageCase.getMultipartReplyMeterFeatures();
        Assert.assertEquals((String)"Wrong maxMeter", (long)10L, (long)message.getMaxMeter().intValue());
        Assert.assertEquals((String)"Wrong bandTypes", (Object)new MeterBandTypeBitmap(Boolean.valueOf(true), Boolean.valueOf(true)), (Object)message.getBandTypes());
        Assert.assertEquals((String)"Wrong capabilities", (Object)new MeterFlags(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true)), (Object)message.getCapabilities());
        Assert.assertEquals((String)"Wrong maxBands", (long)7L, (long)message.getMaxBands().intValue());
        Assert.assertEquals((String)"Wrong maxColor", (long)8L, (long)message.getMaxColor().intValue());
    }

    @Test
    public void testMultipartReplyMeterFeatures2() {
        ByteBuf bb = BufferHelper.buildBuffer("00 0B 00 01 00 00 00 00 00 00 00 09 00 00 00 00 00 00 00 00 03 04 00 00");
        MultipartReplyMessage builtByFactory = (MultipartReplyMessage)BufferHelper.deserialize(this.factory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)11L, (long)builtByFactory.getType().getIntValue());
        Assert.assertEquals((String)"Wrong flag", (Object)true, (Object)builtByFactory.getFlags().isOFPMPFREQMORE());
        MultipartReplyMeterFeaturesCase messageCase = (MultipartReplyMeterFeaturesCase)builtByFactory.getMultipartReplyBody();
        MultipartReplyMeterFeatures message = messageCase.getMultipartReplyMeterFeatures();
        Assert.assertEquals((String)"Wrong maxMeter", (long)9L, (long)message.getMaxMeter().intValue());
        Assert.assertEquals((String)"Wrong bandTypes", (Object)new MeterBandTypeBitmap(Boolean.valueOf(false), Boolean.valueOf(false)), (Object)message.getBandTypes());
        Assert.assertEquals((String)"Wrong capabilities", (Object)new MeterFlags(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false)), (Object)message.getCapabilities());
        Assert.assertEquals((String)"Wrong maxBands", (long)3L, (long)message.getMaxBands().intValue());
        Assert.assertEquals((String)"Wrong maxColor", (long)4L, (long)message.getMaxColor().intValue());
    }
}

