/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories.multipart;

import io.netty.buffer.ByteBuf;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.impl.deserialization.factories.MultipartReplyMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortState;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartReplyMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyPortDescCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.desc._case.MultipartReplyPortDesc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.desc._case.multipart.reply.port.desc.Ports;

public class MultipartReplyPortDescTest {
    private MultipartReplyMessageFactory factory = new MultipartReplyMessageFactory();

    @Test
    public void testEmptyMultipartReplyPortDesc() {
        ByteBuf bb = BufferHelper.buildBuffer("00 0D 00 00 00 00 00 00");
        MultipartReplyMessage builtByFactory = (MultipartReplyMessage)BufferHelper.deserialize(this.factory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)13L, (long)builtByFactory.getType().getIntValue());
        Assert.assertEquals((String)"Wrong flag", (Object)false, (Object)builtByFactory.getFlags().isOFPMPFREQMORE());
        MultipartReplyPortDescCase messageCase = (MultipartReplyPortDescCase)builtByFactory.getMultipartReplyBody();
        MultipartReplyPortDesc message = messageCase.getMultipartReplyPortDesc();
        Assert.assertEquals((String)"Wrong table features size", (long)0L, (long)message.getPorts().size());
    }

    @Test
    public void testMultipartReplyPortDesc() {
        ByteBuf bb = BufferHelper.buildBuffer("00 0D 00 00 00 00 00 00 00 01 02 03 00 00 00 00 08 00 27 00 B0 EB 00 00 4F 70 65 6E 64 61 79 6C 69 67 68 74 00 00 00 00 00 00 00 65 00 00 00 07 00 00 00 81 00 00 FF FF 00 00 C1 89 00 00 C5 8D 00 00 00 81 00 00 00 80 00 00 00 01 00 00 00 00 08 00 27 00 B0 EB 00 00 4F 70 65 6E 64 61 79 6C 69 67 68 74 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 05 00 00 00 06");
        MultipartReplyMessage builtByFactory = (MultipartReplyMessage)BufferHelper.deserialize(this.factory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)13L, (long)builtByFactory.getType().getIntValue());
        Assert.assertEquals((String)"Wrong flag", (Object)false, (Object)builtByFactory.getFlags().isOFPMPFREQMORE());
        MultipartReplyPortDescCase messageCase = (MultipartReplyPortDescCase)builtByFactory.getMultipartReplyBody();
        MultipartReplyPortDesc message = messageCase.getMultipartReplyPortDesc();
        Assert.assertEquals((String)"Wrong port desc size", (long)2L, (long)message.getPorts().size());
        Ports port = (Ports)message.getPorts().get(0);
        Assert.assertEquals((String)"Wrong portNo", (long)66051L, (long)port.getPortNo());
        Assert.assertEquals((String)"Wrong macAddress", (Object)new MacAddress("08:00:27:00:b0:eb"), (Object)port.getHwAddr());
        Assert.assertEquals((String)"Wrong portName", (Object)"Opendaylight", (Object)port.getName());
        Assert.assertEquals((String)"Wrong portConfig", (Object)new PortConfig(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true)), (Object)port.getConfig());
        Assert.assertEquals((String)"Wrong portState", (Object)new PortState(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true)), (Object)port.getState());
        Assert.assertEquals((String)"Wrong currentFeatures", (Object)new PortFeatures(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false)), (Object)port.getCurrentFeatures());
        Assert.assertEquals((String)"Wrong advertisedFeatures", (Object)new PortFeatures(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true)), (Object)port.getAdvertisedFeatures());
        Assert.assertEquals((String)"Wrong supportedFeatures", (Object)new PortFeatures(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true)), (Object)port.getSupportedFeatures());
        Assert.assertEquals((String)"Wrong peerFeatures", (Object)new PortFeatures(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true)), (Object)port.getPeerFeatures());
        Assert.assertEquals((String)"Wrong currSpeed", (long)129L, (long)port.getCurrSpeed());
        Assert.assertEquals((String)"Wrong maxSpeed", (long)128L, (long)port.getMaxSpeed());
        port = (Ports)message.getPorts().get(1);
        Assert.assertEquals((String)"Wrong portNo", (long)1L, (long)port.getPortNo());
        Assert.assertEquals((String)"Wrong macAddress", (Object)new MacAddress("08:00:27:00:b0:eb"), (Object)port.getHwAddr());
        Assert.assertEquals((String)"Wrong portName", (Object)"Opendaylight", (Object)port.getName());
        Assert.assertEquals((String)"Wrong portConfig", (Object)new PortConfig(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false)), (Object)port.getConfig());
        Assert.assertEquals((String)"Wrong portState", (Object)new PortState(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false)), (Object)port.getState());
        Assert.assertEquals((String)"Wrong currentFeatures", (Object)new PortFeatures(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false)), (Object)port.getCurrentFeatures());
        Assert.assertEquals((String)"Wrong advertisedFeatures", (Object)new PortFeatures(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false)), (Object)port.getAdvertisedFeatures());
        Assert.assertEquals((String)"Wrong supportedFeatures", (Object)new PortFeatures(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false)), (Object)port.getSupportedFeatures());
        Assert.assertEquals((String)"Wrong peerFeatures", (Object)new PortFeatures(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false)), (Object)port.getPeerFeatures());
        Assert.assertEquals((String)"Wrong currSpeed", (long)5L, (long)port.getCurrSpeed());
        Assert.assertEquals((String)"Wrong maxSpeed", (long)6L, (long)port.getMaxSpeed());
    }
}

