/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories.multipart;

import io.netty.buffer.ByteBuf;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.impl.deserialization.factories.MultipartReplyMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.NextTableRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.table.features.properties.container.table.feature.properties.NextTableIds;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableFeaturesPropType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartReplyMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyTableFeaturesCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table.features._case.MultipartReplyTableFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table.features._case.multipart.reply.table.features.TableFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.table.features.properties.grouping.TableFeatureProperties;

public class MultipartReplyTableFeaturesTest {
    private MultipartReplyMessageFactory factory = new MultipartReplyMessageFactory();

    @Test
    public void testEmptyMultipartReplyTableFeatures() {
        ByteBuf bb = BufferHelper.buildBuffer("00 0C 00 00 00 00 00 00");
        MultipartReplyMessage builtByFactory = (MultipartReplyMessage)BufferHelper.deserialize(this.factory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)12L, (long)builtByFactory.getType().getIntValue());
        Assert.assertEquals((String)"Wrong flag", (Object)false, (Object)builtByFactory.getFlags().isOFPMPFREQMORE());
        MultipartReplyTableFeaturesCase messageCase = (MultipartReplyTableFeaturesCase)builtByFactory.getMultipartReplyBody();
        MultipartReplyTableFeatures message = messageCase.getMultipartReplyTableFeatures();
        Assert.assertEquals((String)"Wrong table features size", (long)0L, (long)message.getTableFeatures().size());
    }

    @Test
    public void testMultipartReplyTableFeatures() {
        ByteBuf bb = BufferHelper.buildBuffer("00 0C 00 00 00 00 00 00 00 40 01 00 00 00 00 00 4F 70 65 6E 64 61 79 6C 69 67 68 74 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 01 00 00 00 00 00 00 00 02 00 00 00 00 00 00 00 2A 00 40 02 00 00 00 00 00 4F 70 65 6E 64 61 79 6C 69 67 68 74 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 03 00 00 00 00 00 00 00 04 00 00 00 03 00 00 00 2B");
        MultipartReplyMessage builtByFactory = (MultipartReplyMessage)BufferHelper.deserialize(this.factory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)12L, (long)builtByFactory.getType().getIntValue());
        Assert.assertEquals((String)"Wrong flag", (Object)false, (Object)builtByFactory.getFlags().isOFPMPFREQMORE());
        MultipartReplyTableFeaturesCase messageCase = (MultipartReplyTableFeaturesCase)builtByFactory.getMultipartReplyBody();
        MultipartReplyTableFeatures message = messageCase.getMultipartReplyTableFeatures();
        Assert.assertEquals((String)"Wrong table features size", (long)2L, (long)message.getTableFeatures().size());
        TableFeatures feature = (TableFeatures)message.getTableFeatures().get(0);
        Assert.assertEquals((String)"Wrong table id", (long)1L, (long)feature.getTableId().intValue());
        Assert.assertEquals((String)"Wrong name", (Object)"Opendaylight", (Object)feature.getName());
        Assert.assertArrayEquals((String)"Wrong metadata match", (byte[])new byte[]{0, 0, 0, 0, 0, 0, 0, 1}, (byte[])feature.getMetadataMatch());
        Assert.assertArrayEquals((String)"Wrong metadata write", (byte[])new byte[]{0, 0, 0, 0, 0, 0, 0, 2}, (byte[])feature.getMetadataWrite());
        Assert.assertEquals((String)"Wrong config", (Object)false, (Object)feature.getConfig().isOFPTCDEPRECATEDMASK());
        Assert.assertEquals((String)"Wrong max entries", (long)42L, (long)feature.getMaxEntries().intValue());
        feature = (TableFeatures)message.getTableFeatures().get(1);
        Assert.assertEquals((String)"Wrong table id", (long)2L, (long)feature.getTableId().intValue());
        Assert.assertEquals((String)"Wrong name", (Object)"Opendaylight", (Object)feature.getName());
        Assert.assertArrayEquals((String)"Wrong metadata match", (byte[])new byte[]{0, 0, 0, 0, 0, 0, 0, 3}, (byte[])feature.getMetadataMatch());
        Assert.assertArrayEquals((String)"Wrong metadata write", (byte[])new byte[]{0, 0, 0, 0, 0, 0, 0, 4}, (byte[])feature.getMetadataWrite());
        Assert.assertEquals((String)"Wrong config", (Object)true, (Object)feature.getConfig().isOFPTCDEPRECATEDMASK());
        Assert.assertEquals((String)"Wrong max entries", (long)43L, (long)feature.getMaxEntries().intValue());
    }

    @Test
    public void testMultipartReplyTableFeatures2() {
        ByteBuf bb = BufferHelper.buildBuffer("00 0C 00 00 00 00 00 00 00 B0 01 00 00 00 00 00 4F 70 65 6E 64 61 79 6C 69 67 68 74 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 01 00 00 00 00 00 00 00 02 00 00 00 00 00 00 00 2A 00 00 00 04 00 00 00 00 00 01 00 04 00 00 00 00 00 02 00 08 01 02 03 04 00 03 00 07 05 06 07 00 00 04 00 04 00 00 00 00 00 05 00 04 00 00 00 00 00 06 00 04 00 00 00 00 00 07 00 04 00 00 00 00 00 08 00 04 00 00 00 00 00 0A 00 04 00 00 00 00 00 0C 00 04 00 00 00 00 00 0D 00 04 00 00 00 00 00 0E 00 04 00 00 00 00 00 0F 00 04 00 00 00 00");
        MultipartReplyMessage builtByFactory = (MultipartReplyMessage)BufferHelper.deserialize(this.factory, bb);
        BufferHelper.checkHeaderV13((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)12L, (long)builtByFactory.getType().getIntValue());
        Assert.assertEquals((String)"Wrong flag", (Object)false, (Object)builtByFactory.getFlags().isOFPMPFREQMORE());
        MultipartReplyTableFeaturesCase messageCase = (MultipartReplyTableFeaturesCase)builtByFactory.getMultipartReplyBody();
        MultipartReplyTableFeatures message = messageCase.getMultipartReplyTableFeatures();
        Assert.assertEquals((String)"Wrong table features size", (long)1L, (long)message.getTableFeatures().size());
        TableFeatures feature = (TableFeatures)message.getTableFeatures().get(0);
        Assert.assertEquals((String)"Wrong table id", (long)1L, (long)feature.getTableId().intValue());
        Assert.assertEquals((String)"Wrong name", (Object)"Opendaylight", (Object)feature.getName());
        Assert.assertArrayEquals((String)"Wrong metadata match", (byte[])new byte[]{0, 0, 0, 0, 0, 0, 0, 1}, (byte[])feature.getMetadataMatch());
        Assert.assertArrayEquals((String)"Wrong metadata write", (byte[])new byte[]{0, 0, 0, 0, 0, 0, 0, 2}, (byte[])feature.getMetadataWrite());
        Assert.assertEquals((String)"Wrong config", (Object)false, (Object)feature.getConfig().isOFPTCDEPRECATEDMASK());
        Assert.assertEquals((String)"Wrong max entries", (long)42L, (long)feature.getMaxEntries().intValue());
        Assert.assertEquals((String)"Wrong properties size", (long)14L, (long)feature.getTableFeatureProperties().size());
        Assert.assertEquals((String)"Wrong property type", (Object)TableFeaturesPropType.OFPTFPTINSTRUCTIONS, (Object)((TableFeatureProperties)feature.getTableFeatureProperties().get(0)).getType());
        Assert.assertEquals((String)"Wrong property type", (Object)TableFeaturesPropType.OFPTFPTINSTRUCTIONSMISS, (Object)((TableFeatureProperties)feature.getTableFeatureProperties().get(1)).getType());
        TableFeatureProperties property = (TableFeatureProperties)feature.getTableFeatureProperties().get(2);
        Assert.assertEquals((String)"Wrong property type", (Object)TableFeaturesPropType.OFPTFPTNEXTTABLES, (Object)property.getType());
        List tableIds = ((NextTableRelatedTableFeatureProperty)property.getAugmentation(NextTableRelatedTableFeatureProperty.class)).getNextTableIds();
        Assert.assertEquals((String)"Wrong next table id size", (long)4L, (long)tableIds.size());
        Assert.assertEquals((String)"Wrong next table id", (long)1L, (long)((NextTableIds)tableIds.get(0)).getTableId().intValue());
        Assert.assertEquals((String)"Wrong next table id", (long)2L, (long)((NextTableIds)tableIds.get(1)).getTableId().intValue());
        Assert.assertEquals((String)"Wrong next table id", (long)3L, (long)((NextTableIds)tableIds.get(2)).getTableId().intValue());
        Assert.assertEquals((String)"Wrong next table id", (long)4L, (long)((NextTableIds)tableIds.get(3)).getTableId().intValue());
        property = (TableFeatureProperties)feature.getTableFeatureProperties().get(3);
        Assert.assertEquals((String)"Wrong property type", (Object)TableFeaturesPropType.OFPTFPTNEXTTABLESMISS, (Object)property.getType());
        tableIds = ((NextTableRelatedTableFeatureProperty)property.getAugmentation(NextTableRelatedTableFeatureProperty.class)).getNextTableIds();
        Assert.assertEquals((String)"Wrong next table id size", (long)3L, (long)tableIds.size());
        Assert.assertEquals((String)"Wrong next table id", (long)5L, (long)((NextTableIds)tableIds.get(0)).getTableId().intValue());
        Assert.assertEquals((String)"Wrong next table id", (long)6L, (long)((NextTableIds)tableIds.get(1)).getTableId().intValue());
        Assert.assertEquals((String)"Wrong next table id", (long)7L, (long)((NextTableIds)tableIds.get(2)).getTableId().intValue());
        Assert.assertEquals((String)"Wrong property type", (Object)TableFeaturesPropType.OFPTFPTWRITEACTIONS, (Object)((TableFeatureProperties)feature.getTableFeatureProperties().get(4)).getType());
        Assert.assertEquals((String)"Wrong property type", (Object)TableFeaturesPropType.OFPTFPTWRITEACTIONSMISS, (Object)((TableFeatureProperties)feature.getTableFeatureProperties().get(5)).getType());
        Assert.assertEquals((String)"Wrong property type", (Object)TableFeaturesPropType.OFPTFPTAPPLYACTIONS, (Object)((TableFeatureProperties)feature.getTableFeatureProperties().get(6)).getType());
        Assert.assertEquals((String)"Wrong property type", (Object)TableFeaturesPropType.OFPTFPTAPPLYACTIONSMISS, (Object)((TableFeatureProperties)feature.getTableFeatureProperties().get(7)).getType());
        Assert.assertEquals((String)"Wrong property type", (Object)TableFeaturesPropType.OFPTFPTMATCH, (Object)((TableFeatureProperties)feature.getTableFeatureProperties().get(8)).getType());
        Assert.assertEquals((String)"Wrong property type", (Object)TableFeaturesPropType.OFPTFPTWILDCARDS, (Object)((TableFeatureProperties)feature.getTableFeatureProperties().get(9)).getType());
        Assert.assertEquals((String)"Wrong property type", (Object)TableFeaturesPropType.OFPTFPTWRITESETFIELD, (Object)((TableFeatureProperties)feature.getTableFeatureProperties().get(10)).getType());
        Assert.assertEquals((String)"Wrong property type", (Object)TableFeaturesPropType.OFPTFPTWRITESETFIELDMISS, (Object)((TableFeatureProperties)feature.getTableFeatureProperties().get(11)).getType());
        Assert.assertEquals((String)"Wrong property type", (Object)TableFeaturesPropType.OFPTFPTAPPLYSETFIELD, (Object)((TableFeatureProperties)feature.getTableFeatureProperties().get(12)).getType());
        Assert.assertEquals((String)"Wrong property type", (Object)TableFeaturesPropType.OFPTFPTAPPLYSETFIELDMISS, (Object)((TableFeatureProperties)feature.getTableFeatureProperties().get(13)).getType());
    }
}

