/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories.multipart;

import io.netty.buffer.ByteBuf;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.opendaylight.openflowjava.protocol.api.extensibility.DeserializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFDeserializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageCodeKey;
import org.opendaylight.openflowjava.protocol.impl.deserialization.factories.OF10StatsReplyMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartReplyMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.experimenter.core.ExperimenterDataOfChoice;

@RunWith(value=MockitoJUnitRunner.class)
public class OF10StatsReplyExperimenterTest {
    @Mock
    DeserializerRegistry registry;
    @Mock
    private OFDeserializer<ExperimenterDataOfChoice> vendorDeserializer;

    @Test
    public void test() {
        Mockito.when((Object)this.registry.getDeserializer((MessageCodeKey)Matchers.any())).thenReturn(this.vendorDeserializer);
        OF10StatsReplyMessageFactory factory = new OF10StatsReplyMessageFactory();
        factory.injectDeserializerRegistry(this.registry);
        ByteBuf bb = BufferHelper.buildBuffer("FF FF 00 01 00 00 00 00 00 00 00 01");
        MultipartReplyMessage builtByFactory = (MultipartReplyMessage)BufferHelper.deserialize(factory, bb);
        BufferHelper.checkHeaderV10((OfHeader)builtByFactory);
        Assert.assertEquals((String)"Wrong type", (long)65535L, (long)builtByFactory.getType().getIntValue());
        Assert.assertEquals((String)"Wrong flag", (Object)true, (Object)builtByFactory.getFlags().isOFPMPFREQMORE());
        ((OFDeserializer)Mockito.verify(this.vendorDeserializer)).deserialize(bb);
    }
}

