/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.instruction;

import io.netty.buffer.ByteBuf;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.impl.deserialization.instruction.ApplyActionsInstructionDeserializer;
import org.opendaylight.openflowjava.protocol.impl.deserialization.instruction.ClearActionsInstructionDeserializer;
import org.opendaylight.openflowjava.protocol.impl.deserialization.instruction.GoToTableInstructionDeserializer;
import org.opendaylight.openflowjava.protocol.impl.deserialization.instruction.MeterInstructionDeserializer;
import org.opendaylight.openflowjava.protocol.impl.deserialization.instruction.WriteActionsInstructionDeserializer;
import org.opendaylight.openflowjava.protocol.impl.deserialization.instruction.WriteMetadataInstructionDeserializer;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.ApplyActionsCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.ClearActionsCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.GotoTableCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.MeterCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.WriteActionsCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.WriteMetadataCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.grouping.Instruction;

public class AbstractInstructionDeserializerTest {
    @Test
    public void test() {
        ByteBuf buffer = ByteBufUtils.hexStringToByteBuf((String)"00 01 00 04");
        Instruction instruction = new GoToTableInstructionDeserializer().deserializeHeader(buffer);
        Assert.assertTrue((String)"Wrong type", (boolean)(instruction.getInstructionChoice() instanceof GotoTableCase));
        buffer = ByteBufUtils.hexStringToByteBuf((String)"00 02 00 04");
        instruction = new WriteMetadataInstructionDeserializer().deserializeHeader(buffer);
        Assert.assertTrue((String)"Wrong type", (boolean)(instruction.getInstructionChoice() instanceof WriteMetadataCase));
        buffer = ByteBufUtils.hexStringToByteBuf((String)"00 03 00 04");
        instruction = new WriteActionsInstructionDeserializer().deserializeHeader(buffer);
        Assert.assertTrue((String)"Wrong type", (boolean)(instruction.getInstructionChoice() instanceof WriteActionsCase));
        buffer = ByteBufUtils.hexStringToByteBuf((String)"00 04 00 04");
        instruction = new ApplyActionsInstructionDeserializer().deserializeHeader(buffer);
        Assert.assertTrue((String)"Wrong type", (boolean)(instruction.getInstructionChoice() instanceof ApplyActionsCase));
        buffer = ByteBufUtils.hexStringToByteBuf((String)"00 05 00 04");
        instruction = new ClearActionsInstructionDeserializer().deserializeHeader(buffer);
        Assert.assertTrue((String)"Wrong type", (boolean)(instruction.getInstructionChoice() instanceof ClearActionsCase));
        buffer = ByteBufUtils.hexStringToByteBuf((String)"00 06 00 04");
        instruction = new MeterInstructionDeserializer().deserializeHeader(buffer);
        Assert.assertTrue((String)"Wrong type", (boolean)(instruction.getInstructionChoice() instanceof MeterCase));
    }
}

