/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.match;

import io.netty.buffer.ByteBuf;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.impl.deserialization.match.OxmIpv6ExtHdrDeserializer;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.Ipv6ExthdrFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Ipv6Exthdr;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OpenflowBasicClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Ipv6ExthdrCase;

public class OxmIpv6ExtHdrDeserializerTest {
    @Test
    public void test() {
        ByteBuf buffer = BufferHelper.buildBuffer("80 00 4E 02 01 FF");
        buffer.skipBytes(4);
        OxmIpv6ExtHdrDeserializer deserializer = new OxmIpv6ExtHdrDeserializer();
        MatchEntry entry = deserializer.deserialize(buffer);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", Ipv6Exthdr.class, (Object)entry.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)false, (Object)entry.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (Object)new Ipv6ExthdrFlags(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true)), (Object)((Ipv6ExthdrCase)entry.getMatchEntryValue()).getIpv6Exthdr().getPseudoField());
        Assert.assertEquals((String)"Wrong entry mask", null, (Object)((Ipv6ExthdrCase)entry.getMatchEntryValue()).getIpv6Exthdr().getMask());
        Assert.assertTrue((String)"Unread data", (buffer.readableBytes() == 0 ? 1 : 0) != 0);
    }
}

