/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.match;

import io.netty.buffer.ByteBuf;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.impl.deserialization.match.OxmIpv6FlabelDeserializer;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Ipv6Flabel;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OpenflowBasicClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Ipv6FlabelCase;

public class OxmIpv6FlabelDeserializerTest {
    @Test
    public void test() {
        ByteBuf buffer = BufferHelper.buildBuffer("80 00 38 04 00 00 00 02");
        buffer.skipBytes(4);
        OxmIpv6FlabelDeserializer deserializer = new OxmIpv6FlabelDeserializer();
        MatchEntry entry = deserializer.deserialize(buffer);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", Ipv6Flabel.class, (Object)entry.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)false, (Object)entry.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (long)2L, (long)((Ipv6FlabelCase)entry.getMatchEntryValue()).getIpv6Flabel().getIpv6Flabel().getValue().intValue());
    }

    @Test
    public void testWithMask() {
        ByteBuf buffer = BufferHelper.buildBuffer("80 00 39 08 00 00 00 02 00 00 00 05");
        buffer.skipBytes(4);
        OxmIpv6FlabelDeserializer deserializer = new OxmIpv6FlabelDeserializer();
        MatchEntry entry = deserializer.deserialize(buffer);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", Ipv6Flabel.class, (Object)entry.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)true, (Object)entry.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (long)2L, (long)((Ipv6FlabelCase)entry.getMatchEntryValue()).getIpv6Flabel().getIpv6Flabel().getValue().intValue());
        Assert.assertArrayEquals((String)"Wrong entry mask", (byte[])new byte[]{0, 0, 0, 5}, (byte[])((Ipv6FlabelCase)entry.getMatchEntryValue()).getIpv6Flabel().getMask());
    }
}

