/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.match;

import io.netty.buffer.ByteBuf;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.impl.deserialization.match.OxmMetadataDeserializer;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Metadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OpenflowBasicClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.MetadataCase;

public class OxmMetadataDeserializerTest {
    @Test
    public void test() {
        ByteBuf buffer = BufferHelper.buildBuffer("80 00 04 08 00 00 00 00 00 00 00 03");
        buffer.skipBytes(4);
        OxmMetadataDeserializer deserializer = new OxmMetadataDeserializer();
        MatchEntry entry = deserializer.deserialize(buffer);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", Metadata.class, (Object)entry.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)false, (Object)entry.isHasMask());
        Assert.assertArrayEquals((String)"Wrong entry value", (byte[])ByteBufUtils.hexStringToBytes((String)"00 00 00 00 00 00 00 03"), (byte[])((MetadataCase)entry.getMatchEntryValue()).getMetadata().getMetadata());
    }
}

