/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.match;

import io.netty.buffer.ByteBuf;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.impl.deserialization.match.OxmPbbIsidDeserializer;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OpenflowBasicClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.PbbIsid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.PbbIsidCase;

public class OxmPbbIsidDeserializerTest {
    @Test
    public void test() {
        ByteBuf buffer = BufferHelper.buildBuffer("80 00 4A 03 00 00 02");
        buffer.skipBytes(4);
        OxmPbbIsidDeserializer deserializer = new OxmPbbIsidDeserializer();
        MatchEntry entry = deserializer.deserialize(buffer);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", PbbIsid.class, (Object)entry.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)false, (Object)entry.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (long)2L, (long)((PbbIsidCase)entry.getMatchEntryValue()).getPbbIsid().getIsid().intValue());
    }
}

