/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.match;

import io.netty.buffer.ByteBuf;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.impl.deserialization.match.OxmVlanVidDeserializer;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OpenflowBasicClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.VlanVid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.VlanVidCase;

public class OxmVlanVidDeserializerTest {
    @Test
    public void test() {
        ByteBuf buffer = BufferHelper.buildBuffer("80 00 0C 02 20 0A");
        buffer.skipBytes(4);
        OxmVlanVidDeserializer deserializer = new OxmVlanVidDeserializer();
        MatchEntry entry = deserializer.deserialize(buffer);
        Assert.assertEquals((String)"Wrong entry class", OpenflowBasicClass.class, (Object)entry.getOxmClass());
        Assert.assertEquals((String)"Wrong entry field", VlanVid.class, (Object)entry.getOxmMatchField());
        Assert.assertEquals((String)"Wrong entry hasMask", (Object)false, (Object)entry.isHasMask());
        Assert.assertEquals((String)"Wrong entry value", (long)10L, (long)((VlanVidCase)entry.getMatchEntryValue()).getVlanVid().getVlanVid().intValue());
        Assert.assertEquals((String)"Wrong entry value", (Object)false, (Object)((VlanVidCase)entry.getMatchEntryValue()).getVlanVid().isCfiBit());
    }
}

