/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializationFactory;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.HelloInputBuilder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SerializationFactoryTest {
    @Test
    public void test() {
        SerializerRegistryImpl registry = new SerializerRegistryImpl();
        registry.init();
        SerializationFactory factory = new SerializationFactory();
        factory.setSerializerTable((SerializerRegistry)registry);
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        HelloInputBuilder helloBuilder = new HelloInputBuilder();
        helloBuilder.setVersion(Short.valueOf((short)1));
        helloBuilder.setXid(Long.valueOf(123456L));
        helloBuilder.setElements(null);
        factory.messageToBuffer((short)1, buffer, (DataObject)helloBuilder.build());
        Assert.assertEquals((String)"Serialization failed", (long)8L, (long)buffer.readableBytes());
    }

    @Test(expected=IllegalStateException.class)
    public void testNotExistingSerializer() {
        SerializerRegistryImpl registry = new SerializerRegistryImpl();
        registry.init();
        SerializationFactory factory = new SerializationFactory();
        factory.setSerializerTable((SerializerRegistry)registry);
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        HelloInputBuilder helloBuilder = new HelloInputBuilder();
        helloBuilder.setVersion(Short.valueOf((short)1));
        helloBuilder.setXid(Long.valueOf(123456L));
        helloBuilder.setElements(null);
        factory.messageToBuffer((short)0, buffer, (DataObject)helloBuilder.build());
    }
}

