/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization;

import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFGeneralSerializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.OF13MatchSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.grouping.Match;

public class SerializerRegistryImplTest {
    private static final short OF13 = 4;
    private static final short OF10 = 1;

    @Test(expected=IllegalArgumentException.class)
    public void testRegisterSerializerNoArgs() {
        SerializerRegistryImpl serReg = new SerializerRegistryImpl();
        serReg.registerSerializer(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnRegisterSerializerNoMessageTypeKey() {
        SerializerRegistryImpl serReg = new SerializerRegistryImpl();
        serReg.init();
        serReg.registerSerializer(new MessageTypeKey(4, Match.class), (OFGeneralSerializer)new OF13MatchSerializer());
        serReg.unregisterSerializer(null);
    }

    @Test
    public void testUnRegisterSerializer() {
        SerializerRegistryImpl serReg = new SerializerRegistryImpl();
        serReg.init();
        serReg.registerSerializer(new MessageTypeKey(4, Match.class), (OFGeneralSerializer)new OF13MatchSerializer());
        Assert.assertTrue((String)"Wrong - unregister serializer", (boolean)serReg.unregisterSerializer(new MessageTypeKey(4, Match.class)));
        serReg.registerSerializer(new MessageTypeKey(4, Match.class), (OFGeneralSerializer)new OF13MatchSerializer());
        Assert.assertFalse((String)"Wrong - unregister serializer", (boolean)serReg.unregisterSerializer(new MessageTypeKey(1, Match.class)));
    }
}

