/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.action;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.keys.MatchEntrySerializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.serialization.action.OF13SetFieldActionSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.oxm.container.match.entry.value.ExperimenterIdCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.oxm.container.match.entry.value.experimenter.id._case.ExperimenterBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.ActionChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetFieldCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.set.field._case.SetFieldActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.ActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ExperimenterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.ExperimenterClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchField;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.MatchEntryValue;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class OF13SetFieldActionSerializerTest {
    private SerializerRegistry registry;
    @Mock
    OFSerializer<MatchEntry> serializerMock;

    @Before
    public void startUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.registry = new SerializerRegistryImpl();
        this.registry.init();
    }

    @Test
    public void test() {
        OF13SetFieldActionSerializer ser = new OF13SetFieldActionSerializer();
        ser.injectSerializerRegistry(this.registry);
        ActionBuilder actionBuilder = new ActionBuilder();
        long experimenterId = 12L;
        ExperimenterIdCaseBuilder expCaseBuilder = new ExperimenterIdCaseBuilder();
        ExperimenterBuilder expBuilder = new ExperimenterBuilder();
        expBuilder.setExperimenter(new ExperimenterId(Long.valueOf(experimenterId)));
        expCaseBuilder.setExperimenter(expBuilder.build());
        MatchEntryBuilder meb = new MatchEntryBuilder();
        meb.setOxmClass(ExperimenterClass.class);
        meb.setOxmMatchField(OxmMatchFieldClass.class);
        meb.setMatchEntryValue((MatchEntryValue)expCaseBuilder.build());
        ArrayList<MatchEntry> matchEntry = new ArrayList<MatchEntry>();
        MatchEntry me = meb.build();
        matchEntry.add(me);
        SetFieldCaseBuilder caseBuilder = new SetFieldCaseBuilder();
        SetFieldActionBuilder setFieldBuilder = new SetFieldActionBuilder();
        setFieldBuilder.setMatchEntry(matchEntry);
        caseBuilder.setSetFieldAction(setFieldBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)caseBuilder.build());
        MatchEntrySerializerKey key = new MatchEntrySerializerKey(4, ExperimenterClass.class, OxmMatchFieldClass.class);
        key.setExperimenterId(Long.valueOf(experimenterId));
        this.registry.registerSerializer((MessageTypeKey)key, this.serializerMock);
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        ser.serialize(actionBuilder.build(), out);
        ((OFSerializer)Mockito.verify(this.serializerMock, (VerificationMode)Mockito.times((int)1))).serialize((DataContainer)((MatchEntry)Mockito.anyObject()), (ByteBuf)Mockito.anyObject());
        int lenght = out.readableBytes();
        Assert.assertEquals((String)"Wrong - bad field code", (long)25L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong - bad lenght", (long)lenght, (long)out.readUnsignedShort());
    }

    private class OxmMatchFieldClass
    extends MatchField {
        private OxmMatchFieldClass() {
        }
    }
}

