/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.EchoInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.EchoInputBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class EchoInputMessageFactoryTest {
    private static final byte ECHO_REQUEST_MESSAGE_CODE_TYPE = 2;
    private SerializerRegistry registry;
    private OFSerializer<EchoInput> echoFactory;

    @Before
    public void startUp() {
        this.registry = new SerializerRegistryImpl();
        this.registry.init();
        this.echoFactory = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(4, EchoInput.class));
    }

    @Test
    public void testV13() throws Exception {
        EchoInputBuilder eib = new EchoInputBuilder();
        BufferHelper.setupHeader(eib, 4);
        EchoInput ei = eib.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.echoFactory.serialize((DataContainer)ei, out);
        BufferHelper.checkHeaderV13(out, (byte)2, 8);
    }

    @Test
    public void testV10() throws Exception {
        EchoInputBuilder eib = new EchoInputBuilder();
        BufferHelper.setupHeader(eib, 1);
        EchoInput ei = eib.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.echoFactory.serialize((DataContainer)ei, out);
        BufferHelper.checkHeaderV10(out, (byte)2, 8);
    }

    @Test
    public void testData() throws Exception {
        byte[] dataToTest = new byte[]{91, 92, 93, 94, 95, 96, 97, 98};
        EchoInputBuilder eib = new EchoInputBuilder();
        BufferHelper.setupHeader(eib, 4);
        eib.setData(dataToTest);
        EchoInput ei = eib.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.echoFactory.serialize((DataContainer)ei, out);
        BufferHelper.checkHeaderV13(out, (byte)2, 8 + dataToTest.length);
        byte[] outData = new byte[dataToTest.length];
        out.readBytes(outData);
        Assert.assertArrayEquals((String)"Wrong - different output data.", (byte[])dataToTest, (byte[])outData);
        out.release();
    }
}

