/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.EchoReplyInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.EchoReplyInputBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class EchoReplyInputMessageFactoryTest {
    private static final byte ECHO_REPLY_MESSAGE_CODE_TYPE = 3;
    private SerializerRegistry registry;
    private OFSerializer<EchoReplyInput> echoFactory;

    @Before
    public void startUp() {
        this.registry = new SerializerRegistryImpl();
        this.registry.init();
        this.echoFactory = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(4, EchoReplyInput.class));
    }

    @Test
    public void testV13() throws Exception {
        EchoReplyInputBuilder erib = new EchoReplyInputBuilder();
        BufferHelper.setupHeader(erib, 4);
        EchoReplyInput eri = erib.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.echoFactory.serialize((DataContainer)eri, out);
        BufferHelper.checkHeaderV13(out, (byte)3, 8);
    }

    @Test
    public void testV10() throws Exception {
        EchoReplyInputBuilder erib = new EchoReplyInputBuilder();
        BufferHelper.setupHeader(erib, 1);
        EchoReplyInput eri = erib.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.echoFactory.serialize((DataContainer)eri, out);
        BufferHelper.checkHeaderV10(out, (byte)3, 8);
    }

    @Test
    public void testDataSerialize() throws Exception {
        byte[] dataToTest = new byte[]{91, 92, 93, 94, 95, 96, 97, 98};
        EchoReplyInputBuilder erib = new EchoReplyInputBuilder();
        BufferHelper.setupHeader(erib, 4);
        erib.setData(dataToTest);
        EchoReplyInput eri = erib.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.echoFactory.serialize((DataContainer)eri, out);
        BufferHelper.checkHeaderV13(out, (byte)3, 8 + dataToTest.length);
        byte[] outData = new byte[dataToTest.length];
        out.readBytes(outData);
        Assert.assertArrayEquals((String)"Wrong - different output data.", (byte[])dataToTest, (byte[])outData);
        out.release();
    }
}

