/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ErrorMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ErrorMessageBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class ErrorMessageFactoryTest {
    private static final byte MESSAGE_TYPE = 1;
    private OFSerializer<ErrorMessage> factory;

    @Before
    public void startUp() {
        SerializerRegistryImpl registry = new SerializerRegistryImpl();
        registry.init();
        this.factory = (OFSerializer)registry.getSerializer(new MessageTypeKey(4, ErrorMessage.class));
    }

    @Test
    public void testSerialize() throws Exception {
        ErrorMessageBuilder builder = new ErrorMessageBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setType(Integer.valueOf(10));
        builder.setCode(Integer.valueOf(20));
        byte[] data = ByteBufUtils.hexStringToBytes((String)"00 00 01 02 03 04 05 06 07 08 09 10 11 12 13 14");
        builder.setData(data);
        ErrorMessage message = builder.build();
        ByteBuf serializedBuffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.factory.serialize((DataContainer)message, serializedBuffer);
        BufferHelper.checkHeaderV13(serializedBuffer, (byte)1, 28);
        Assert.assertEquals((String)"Wrong Type", (long)message.getType().intValue(), (long)serializedBuffer.readShort());
        Assert.assertEquals((String)"Wrong Code", (long)message.getCode().intValue(), (long)serializedBuffer.readShort());
        byte[] readData = new byte[serializedBuffer.readableBytes()];
        serializedBuffer.readBytes(readData);
        Assert.assertArrayEquals((String)"Wrong data", (byte[])message.getData(), (byte[])readData);
    }
}

