/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistryInjector;
import org.opendaylight.openflowjava.protocol.api.keys.ExperimenterIdSerializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.serialization.factories.ExperimenterInputMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ExperimenterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ExperimenterInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ExperimenterInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ExperimenterOfMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.experimenter.core.ExperimenterDataOfChoice;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class ExperimenterInputMessageFactoryTest {
    @Mock
    SerializerRegistry registry;
    @Mock
    private OFSerializer<ExperimenterDataOfChoice> serializer;
    private OFSerializer<ExperimenterOfMessage> expFactory;
    @Mock
    private ExperimenterDataOfChoice vendorData;
    @Mock
    private ByteBuf out;

    public void startUp(boolean real) {
        MockitoAnnotations.initMocks((Object)this);
        this.expFactory = new ExperimenterInputMessageFactory();
        if (real) {
            SerializerRegistryImpl realRegistry = new SerializerRegistryImpl();
            realRegistry.init();
            ((SerializerRegistryInjector)this.expFactory).injectSerializerRegistry((SerializerRegistry)realRegistry);
        } else {
            ((SerializerRegistryInjector)this.expFactory).injectSerializerRegistry(this.registry);
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testV10Real() throws Exception {
        this.startUp(true);
        ExperimenterInputBuilder builder = new ExperimenterInputBuilder();
        BufferHelper.setupHeader(builder, 1);
        builder.setExperimenter(new ExperimenterId(Long.valueOf(42L)));
        builder.setExpType(Long.valueOf(21L));
        builder.setExperimenterDataOfChoice(this.vendorData);
        ExperimenterInput input = builder.build();
        this.expFactory.serialize((DataContainer)input, this.out);
    }

    @Test(expected=IllegalStateException.class)
    public void testV13Real() throws Exception {
        this.startUp(true);
        ExperimenterInputBuilder builder = new ExperimenterInputBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setExperimenter(new ExperimenterId(Long.valueOf(42L)));
        builder.setExpType(Long.valueOf(22L));
        builder.setExperimenterDataOfChoice(this.vendorData);
        ExperimenterInput input = builder.build();
        this.expFactory.serialize((DataContainer)input, this.out);
    }

    @Test
    public void testV10() throws Exception {
        this.startUp(false);
        ExperimenterInputBuilder builder = new ExperimenterInputBuilder();
        BufferHelper.setupHeader(builder, 1);
        builder.setExperimenter(new ExperimenterId(Long.valueOf(42L)));
        builder.setExpType(Long.valueOf(21L));
        builder.setExperimenterDataOfChoice(this.vendorData);
        ExperimenterInput input = builder.build();
        Mockito.when((Object)this.registry.getSerializer((MessageTypeKey)((ExperimenterIdSerializerKey)Matchers.any()))).thenReturn(this.serializer);
        this.expFactory.serialize((DataContainer)input, this.out);
        ((OFSerializer)Mockito.verify(this.serializer, (VerificationMode)Mockito.times((int)1))).serialize((DataContainer)input.getExperimenterDataOfChoice(), this.out);
    }

    @Test
    public void testV13() throws Exception {
        this.startUp(false);
        ExperimenterInputBuilder builder = new ExperimenterInputBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setExperimenter(new ExperimenterId(Long.valueOf(42L)));
        builder.setExpType(Long.valueOf(21L));
        builder.setExperimenterDataOfChoice(this.vendorData);
        ExperimenterInput input = builder.build();
        Mockito.when((Object)this.registry.getSerializer((MessageTypeKey)((ExperimenterIdSerializerKey)Matchers.any()))).thenReturn(this.serializer);
        this.expFactory.serialize((DataContainer)input, this.out);
        ((OFSerializer)Mockito.verify(this.serializer, (VerificationMode)Mockito.times((int)1))).serialize((DataContainer)input.getExperimenterDataOfChoice(), this.out);
    }
}

