/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.math.BigInteger;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.ActionChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.OutputActionCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.output.action._case.OutputActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.ActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.InstructionChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.ApplyActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.GotoTableCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.WriteMetadataCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice._goto.table._case.GotoTableBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.apply.actions._case.ApplyActionsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.write.metadata._case.WriteMetadataBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.grouping.Instruction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.grouping.InstructionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowModCommand;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowModFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.InPhyPort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.IpEcn;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OpenflowBasicClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OxmMatchType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.MatchEntryValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.InPhyPortCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.IpEcnCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.in.phy.port._case.InPhyPortBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ip.ecn._case.IpEcnBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.grouping.MatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowModInputBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class FlowModInputMessageFactoryTest {
    private static final byte PADDING_IN_FLOW_MOD_MESSAGE = 2;
    private SerializerRegistry registry;
    private OFSerializer<FlowModInput> flowModFactory;

    @Before
    public void startUp() {
        this.registry = new SerializerRegistryImpl();
        this.registry.init();
        this.flowModFactory = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(4, FlowModInput.class));
    }

    @Test
    public void testFlowModInputMessageFactory() throws Exception {
        FlowModInputBuilder builder = new FlowModInputBuilder();
        BufferHelper.setupHeader(builder, 4);
        byte[] cookie = new byte[]{-1, 1, 4, 1, 6, 0, 7, 1};
        builder.setCookie(new BigInteger(1, cookie));
        byte[] cookieMask = new byte[]{-1, 5, 0, 0, 9, 48, 0, 48};
        builder.setCookieMask(new BigInteger(1, cookieMask));
        builder.setTableId(new TableId(Long.valueOf(65L)));
        builder.setCommand(FlowModCommand.forValue((int)2));
        builder.setIdleTimeout(Integer.valueOf(12));
        builder.setHardTimeout(Integer.valueOf(0));
        builder.setPriority(Integer.valueOf(126));
        builder.setBufferId(Long.valueOf(2L));
        builder.setOutPort(new PortNumber(Long.valueOf(4422L)));
        builder.setOutGroup(Long.valueOf(98L));
        builder.setFlags(new FlowModFlags(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true)));
        MatchBuilder matchBuilder = new MatchBuilder();
        matchBuilder.setType(OxmMatchType.class);
        ArrayList<MatchEntry> entries = new ArrayList<MatchEntry>();
        MatchEntryBuilder entriesBuilder = new MatchEntryBuilder();
        entriesBuilder.setOxmClass(OpenflowBasicClass.class);
        entriesBuilder.setOxmMatchField(InPhyPort.class);
        entriesBuilder.setHasMask(Boolean.valueOf(false));
        InPhyPortCaseBuilder inPhyPortCaseBuilder = new InPhyPortCaseBuilder();
        InPhyPortBuilder inPhyPortBuilder = new InPhyPortBuilder();
        inPhyPortBuilder.setPortNumber(new PortNumber(Long.valueOf(42L)));
        inPhyPortCaseBuilder.setInPhyPort(inPhyPortBuilder.build());
        entriesBuilder.setMatchEntryValue((MatchEntryValue)inPhyPortCaseBuilder.build());
        entries.add(entriesBuilder.build());
        entriesBuilder.setOxmClass(OpenflowBasicClass.class);
        entriesBuilder.setOxmMatchField(IpEcn.class);
        entriesBuilder.setHasMask(Boolean.valueOf(false));
        IpEcnCaseBuilder ipEcnCaseBuilder = new IpEcnCaseBuilder();
        IpEcnBuilder ipEcnBuilder = new IpEcnBuilder();
        ipEcnBuilder.setEcn(Short.valueOf((short)4));
        ipEcnCaseBuilder.setIpEcn(ipEcnBuilder.build());
        entriesBuilder.setMatchEntryValue((MatchEntryValue)ipEcnCaseBuilder.build());
        entries.add(entriesBuilder.build());
        matchBuilder.setMatchEntry(entries);
        builder.setMatch(matchBuilder.build());
        ArrayList<Instruction> instructions = new ArrayList<Instruction>();
        InstructionBuilder insBuilder = new InstructionBuilder();
        GotoTableCaseBuilder goToCaseBuilder = new GotoTableCaseBuilder();
        GotoTableBuilder instructionBuilder = new GotoTableBuilder();
        instructionBuilder.setTableId(Short.valueOf((short)43));
        goToCaseBuilder.setGotoTable(instructionBuilder.build());
        insBuilder.setInstructionChoice((InstructionChoice)goToCaseBuilder.build());
        instructions.add(insBuilder.build());
        WriteMetadataCaseBuilder metadataCaseBuilder = new WriteMetadataCaseBuilder();
        WriteMetadataBuilder metadataBuilder = new WriteMetadataBuilder();
        metadataBuilder.setMetadata(cookie);
        metadataBuilder.setMetadataMask(cookieMask);
        metadataCaseBuilder.setWriteMetadata(metadataBuilder.build());
        insBuilder.setInstructionChoice((InstructionChoice)metadataCaseBuilder.build());
        instructions.add(insBuilder.build());
        insBuilder = new InstructionBuilder();
        ApplyActionsCaseBuilder applyActionsCaseBuilder = new ApplyActionsCaseBuilder();
        ApplyActionsBuilder actionsBuilder = new ApplyActionsBuilder();
        ArrayList<Action> actions = new ArrayList<Action>();
        ActionBuilder actionBuilder = new ActionBuilder();
        OutputActionCaseBuilder caseBuilder = new OutputActionCaseBuilder();
        OutputActionBuilder outputBuilder = new OutputActionBuilder();
        outputBuilder.setPort(new PortNumber(Long.valueOf(42L)));
        outputBuilder.setMaxLength(Integer.valueOf(52));
        caseBuilder.setOutputAction(outputBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)caseBuilder.build());
        actions.add(actionBuilder.build());
        actionsBuilder.setAction(actions);
        applyActionsCaseBuilder.setApplyActions(actionsBuilder.build());
        insBuilder.setInstructionChoice((InstructionChoice)applyActionsCaseBuilder.build());
        instructions.add(insBuilder.build());
        builder.setInstruction(instructions);
        FlowModInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.flowModFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV13(out, (byte)14, 128);
        cookie = new byte[8];
        out.readBytes(cookie);
        Assert.assertEquals((String)"Wrong cookie", (Object)message.getCookie(), (Object)new BigInteger(1, cookie));
        cookieMask = new byte[8];
        out.readBytes(cookieMask);
        Assert.assertEquals((String)"Wrong cookieMask", (Object)message.getCookieMask(), (Object)new BigInteger(1, cookieMask));
        Assert.assertEquals((String)"Wrong tableId", (long)message.getTableId().getValue().intValue(), (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong command", (long)message.getCommand().getIntValue(), (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong idleTimeOut", (long)message.getIdleTimeout().intValue(), (long)out.readShort());
        Assert.assertEquals((String)"Wrong hardTimeOut", (long)message.getHardTimeout().intValue(), (long)out.readShort());
        Assert.assertEquals((String)"Wrong priority", (long)message.getPriority().intValue(), (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong bufferId", (long)message.getBufferId().intValue(), (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong outPort", (long)message.getOutPort().getValue().intValue(), (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong outGroup", (long)message.getOutGroup().intValue(), (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong flags", (Object)message.getFlags(), (Object)FlowModInputMessageFactoryTest.createFlowModFlagsFromBitmap(out.readUnsignedShort()));
        out.skipBytes(2);
        Assert.assertEquals((String)"Wrong match type", (long)1L, (long)out.readUnsignedShort());
        out.skipBytes(2);
        Assert.assertEquals((String)"Wrong oxm class", (long)32768L, (long)out.readUnsignedShort());
        short fieldAndMask = out.readUnsignedByte();
        Assert.assertEquals((String)"Wrong oxm hasMask", (long)0L, (long)(fieldAndMask & 1));
        Assert.assertEquals((String)"Wrong oxm field", (long)1L, (long)(fieldAndMask >> 1));
        out.skipBytes(1);
        Assert.assertEquals((String)"Wrong oxm value", (long)42L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong oxm class", (long)32768L, (long)out.readUnsignedShort());
        fieldAndMask = out.readUnsignedByte();
        Assert.assertEquals((String)"Wrong oxm hasMask", (long)0L, (long)(fieldAndMask & 1));
        Assert.assertEquals((String)"Wrong oxm field", (long)9L, (long)(fieldAndMask >> 1));
        out.skipBytes(1);
        Assert.assertEquals((String)"Wrong oxm value", (long)4L, (long)out.readUnsignedByte());
        out.skipBytes(7);
        Assert.assertEquals((String)"Wrong instruction type", (long)1L, (long)out.readUnsignedShort());
        out.skipBytes(2);
        Assert.assertEquals((String)"Wrong instruction value", (long)43L, (long)out.readUnsignedByte());
        out.skipBytes(3);
        Assert.assertEquals((String)"Wrong instruction type", (long)2L, (long)out.readUnsignedShort());
        out.skipBytes(2);
        out.skipBytes(4);
        byte[] cookieRead = new byte[8];
        out.readBytes(cookieRead);
        byte[] cookieMaskRead = new byte[8];
        out.readBytes(cookieMaskRead);
        Assert.assertArrayEquals((String)"Wrong metadata", (byte[])cookie, (byte[])cookieRead);
        Assert.assertArrayEquals((String)"Wrong metadata mask", (byte[])cookieMask, (byte[])cookieMaskRead);
        Assert.assertEquals((String)"Wrong instruction type", (long)4L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction length", (long)24L, (long)out.readUnsignedShort());
        out.skipBytes(4);
        Assert.assertEquals((String)"Wrong action type", (long)0L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)16L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong port", (long)42L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong max-length", (long)52L, (long)out.readUnsignedShort());
        out.skipBytes(6);
        Assert.assertTrue((String)"Unread data", (out.readableBytes() == 0 ? 1 : 0) != 0);
    }

    private static FlowModFlags createFlowModFlagsFromBitmap(int input) {
        Boolean _oFPFFSENDFLOWREM = (input & 1) > 0;
        Boolean _oFPFFCHECKOVERLAP = (input & 2) > 0;
        Boolean _oFPFFRESETCOUNTS = (input & 4) > 0;
        Boolean _oFPFFNOPKTCOUNTS = (input & 8) > 0;
        Boolean _oFPFFNOBYTCOUNTS = (input & 0x10) > 0;
        return new FlowModFlags(_oFPFFCHECKOVERLAP, _oFPFFNOBYTCOUNTS, _oFPFFNOPKTCOUNTS, _oFPFFRESETCOUNTS, _oFPFFSENDFLOWREM);
    }
}

