/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.math.BigInteger;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowRemovedReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.InPhyPort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.IpEcn;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OpenflowBasicClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OxmMatchType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.MatchEntryValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.InPhyPortCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.IpEcnCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.in.phy.port._case.InPhyPortBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ip.ecn._case.IpEcnBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.grouping.MatchBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowRemovedMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowRemovedMessageBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class FlowRemovedMessageFactoryTest {
    private OFSerializer<FlowRemovedMessage> factory;
    private static final byte MESSAGE_TYPE = 11;

    @Before
    public void startUp() {
        SerializerRegistryImpl registry = new SerializerRegistryImpl();
        registry.init();
        this.factory = (OFSerializer)registry.getSerializer(new MessageTypeKey(4, FlowRemovedMessage.class));
    }

    @Test
    public void testSerialize() throws Exception {
        FlowRemovedMessageBuilder builder = new FlowRemovedMessageBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setCookie(BigInteger.valueOf(1234L));
        builder.setPriority(Integer.valueOf(1234));
        builder.setReason(FlowRemovedReason.forValue((int)2));
        builder.setTableId(new TableId(Long.valueOf(65L)));
        builder.setDurationSec(Long.valueOf(1234L));
        builder.setDurationNsec(Long.valueOf(1234L));
        builder.setIdleTimeout(Integer.valueOf(1234));
        builder.setHardTimeout(Integer.valueOf(1234));
        builder.setPacketCount(BigInteger.valueOf(1234L));
        builder.setByteCount(BigInteger.valueOf(1234L));
        MatchBuilder matchBuilder = new MatchBuilder();
        matchBuilder.setType(OxmMatchType.class);
        ArrayList<MatchEntry> entries = new ArrayList<MatchEntry>();
        MatchEntryBuilder entriesBuilder = new MatchEntryBuilder();
        entriesBuilder.setOxmClass(OpenflowBasicClass.class);
        entriesBuilder.setOxmMatchField(InPhyPort.class);
        entriesBuilder.setHasMask(Boolean.valueOf(false));
        InPhyPortCaseBuilder inPhyPortCaseBuilder = new InPhyPortCaseBuilder();
        InPhyPortBuilder inPhyPortBuilder = new InPhyPortBuilder();
        inPhyPortBuilder.setPortNumber(new PortNumber(Long.valueOf(42L)));
        inPhyPortCaseBuilder.setInPhyPort(inPhyPortBuilder.build());
        entriesBuilder.setMatchEntryValue((MatchEntryValue)inPhyPortCaseBuilder.build());
        entries.add(entriesBuilder.build());
        entriesBuilder.setOxmClass(OpenflowBasicClass.class);
        entriesBuilder.setOxmMatchField(IpEcn.class);
        entriesBuilder.setHasMask(Boolean.valueOf(false));
        IpEcnCaseBuilder ipEcnCaseBuilder = new IpEcnCaseBuilder();
        IpEcnBuilder ipEcnBuilder = new IpEcnBuilder();
        ipEcnBuilder.setEcn(Short.valueOf((short)4));
        ipEcnCaseBuilder.setIpEcn(ipEcnBuilder.build());
        entriesBuilder.setMatchEntryValue((MatchEntryValue)ipEcnCaseBuilder.build());
        entries.add(entriesBuilder.build());
        matchBuilder.setMatchEntry(entries);
        builder.setMatch(matchBuilder.build());
        FlowRemovedMessage message = builder.build();
        ByteBuf serializedBuffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.factory.serialize((DataContainer)message, serializedBuffer);
        BufferHelper.checkHeaderV13(serializedBuffer, (byte)11, 72);
        Assert.assertEquals((String)"Wrong cookie", (long)message.getCookie().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong priority", (long)message.getPriority().intValue(), (long)serializedBuffer.readShort());
        Assert.assertEquals((String)"Wrong reason", (long)message.getReason().getIntValue(), (long)serializedBuffer.readByte());
        Assert.assertEquals((String)"Wrong Table ID", (long)message.getTableId().getValue().intValue(), (long)serializedBuffer.readUnsignedByte());
        Assert.assertEquals((String)"Wrong duration sec", (long)message.getDurationSec().intValue(), (long)serializedBuffer.readInt());
        Assert.assertEquals((String)"Wrong duration nsec", (long)message.getDurationNsec().intValue(), (long)serializedBuffer.readInt());
        Assert.assertEquals((String)"Wrong Idle timeout", (long)message.getIdleTimeout().intValue(), (long)serializedBuffer.readShort());
        Assert.assertEquals((String)"Wrong Hard timeout", (long)message.getIdleTimeout().intValue(), (long)serializedBuffer.readShort());
        Assert.assertEquals((String)"Wrong Packet count", (long)message.getPacketCount().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong Byte count", (long)message.getByteCount().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong match type", (long)1L, (long)serializedBuffer.readUnsignedShort());
        serializedBuffer.skipBytes(2);
        Assert.assertEquals((String)"Wrong oxm class", (long)32768L, (long)serializedBuffer.readUnsignedShort());
        short fieldAndMask = serializedBuffer.readUnsignedByte();
        Assert.assertEquals((String)"Wrong oxm hasMask", (long)0L, (long)(fieldAndMask & 1));
        Assert.assertEquals((String)"Wrong oxm field", (long)1L, (long)(fieldAndMask >> 1));
        serializedBuffer.skipBytes(1);
        Assert.assertEquals((String)"Wrong oxm value", (long)42L, (long)serializedBuffer.readUnsignedInt());
        Assert.assertEquals((String)"Wrong oxm class", (long)32768L, (long)serializedBuffer.readUnsignedShort());
        fieldAndMask = serializedBuffer.readUnsignedByte();
        Assert.assertEquals((String)"Wrong oxm hasMask", (long)0L, (long)(fieldAndMask & 1));
        Assert.assertEquals((String)"Wrong oxm field", (long)9L, (long)(fieldAndMask >> 1));
        serializedBuffer.skipBytes(1);
        Assert.assertEquals((String)"Wrong oxm value", (long)4L, (long)serializedBuffer.readUnsignedByte());
        serializedBuffer.skipBytes(7);
    }
}

