/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetConfigInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetConfigInputBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class GetConfigInputMessageFactoryTest {
    private static final byte GET_CONFIG_REQUEST_MESSAGE_CODE_TYPE = 7;
    private SerializerRegistry registry;
    private OFSerializer<GetConfigInput> getConfigFactory;

    @Before
    public void startUp() {
        this.registry = new SerializerRegistryImpl();
        this.registry.init();
        this.getConfigFactory = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(4, GetConfigInput.class));
    }

    @Test
    public void testV13() throws Exception {
        GetConfigInputBuilder gcib = new GetConfigInputBuilder();
        BufferHelper.setupHeader(gcib, 4);
        GetConfigInput gci = gcib.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.getConfigFactory.serialize((DataContainer)gci, out);
        BufferHelper.checkHeaderV13(out, (byte)7, 8);
    }

    @Test
    public void testV10() throws Exception {
        GetConfigInputBuilder gcib = new GetConfigInputBuilder();
        BufferHelper.setupHeader(gcib, 1);
        GetConfigInput gci = gcib.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.getConfigFactory.serialize((DataContainer)gci, out);
        BufferHelper.checkHeaderV10(out, (byte)7, 8);
    }
}

