/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.SwitchConfigFlag;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetConfigOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetConfigOutputBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class GetConfigReplyMessageFactoryTest {
    private static final byte MESSAGE_TYPE = 8;
    private OFSerializer<GetConfigOutput> factory;

    @Before
    public void startUp() {
        SerializerRegistryImpl registry = new SerializerRegistryImpl();
        registry.init();
        this.factory = (OFSerializer)registry.getSerializer(new MessageTypeKey(4, GetConfigOutput.class));
    }

    @Test
    public void testSerialize() throws Exception {
        GetConfigOutputBuilder builder = new GetConfigOutputBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setFlags(SwitchConfigFlag.forValue((int)2));
        builder.setMissSendLen(Integer.valueOf(20));
        GetConfigOutput message = builder.build();
        ByteBuf serializedBuffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.factory.serialize((DataContainer)message, serializedBuffer);
        BufferHelper.checkHeaderV13(serializedBuffer, (byte)8, 12);
        Assert.assertEquals((String)"Wrong Type", (long)message.getFlags().getIntValue(), (long)serializedBuffer.readShort());
        Assert.assertEquals((String)"Wrong Code", (long)message.getMissSendLen().intValue(), (long)serializedBuffer.readShort());
    }
}

