/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetFeaturesInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetFeaturesInputBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class GetFeaturesInputMessageFactoryTest {
    private static final byte FEATURES_REQUEST_MESSAGE_CODE_TYPE = 5;
    private SerializerRegistry registry;
    private OFSerializer<GetFeaturesInput> featuresFactory;

    @Before
    public void startUp() {
        this.registry = new SerializerRegistryImpl();
        this.registry.init();
        this.featuresFactory = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(4, GetFeaturesInput.class));
    }

    @Test
    public void testV13() throws Exception {
        GetFeaturesInputBuilder gfib = new GetFeaturesInputBuilder();
        BufferHelper.setupHeader(gfib, 4);
        GetFeaturesInput gfi = gfib.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.featuresFactory.serialize((DataContainer)gfi, out);
        BufferHelper.checkHeaderV13(out, (byte)5, 8);
    }

    @Test
    public void testV10() throws Exception {
        GetFeaturesInputBuilder gfib = new GetFeaturesInputBuilder();
        BufferHelper.setupHeader(gfib, 1);
        GetFeaturesInput gfi = gfib.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.featuresFactory.serialize((DataContainer)gfi, out);
        BufferHelper.checkHeaderV10(out, (byte)5, 8);
    }
}

