/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.math.BigInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.Capabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetFeaturesOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetFeaturesOutputBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class GetFeaturesOutputFactoryTest {
    private OFSerializer<GetFeaturesOutput> factory;
    private static final byte MESSAGE_TYPE = 6;
    private static final byte PADDING = 2;

    @Before
    public void startUp() {
        SerializerRegistryImpl registry = new SerializerRegistryImpl();
        registry.init();
        this.factory = (OFSerializer)registry.getSerializer(new MessageTypeKey(4, GetFeaturesOutput.class));
    }

    @Test
    public void testSerialize() throws Exception {
        GetFeaturesOutputBuilder builder = new GetFeaturesOutputBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setDatapathId(BigInteger.valueOf(1234L));
        builder.setBuffers(Long.valueOf(1234L));
        builder.setTables(Short.valueOf((short)12));
        builder.setAuxiliaryId(Short.valueOf((short)12));
        builder.setCapabilities(new Capabilities(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true)));
        builder.setReserved(Long.valueOf(1234L));
        GetFeaturesOutput message = builder.build();
        ByteBuf serializedBuffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.factory.serialize((DataContainer)message, serializedBuffer);
        BufferHelper.checkHeaderV13(serializedBuffer, (byte)6, 32);
        Assert.assertEquals((String)"Wrong DatapathId", (long)message.getDatapathId().longValue(), (long)serializedBuffer.readLong());
        Assert.assertEquals((String)"Wrong Buffer ID", (long)message.getBuffers(), (long)serializedBuffer.readInt());
        Assert.assertEquals((String)"Wrong tables", (long)message.getTables().shortValue(), (long)serializedBuffer.readUnsignedByte());
        Assert.assertEquals((String)"Wrong auxiliary ID", (long)message.getAuxiliaryId().shortValue(), (long)serializedBuffer.readUnsignedByte());
        serializedBuffer.skipBytes(2);
        Assert.assertEquals((String)"Wrong Capabilities", (Object)message.getCapabilities(), (Object)GetFeaturesOutputFactoryTest.createCapabilities(serializedBuffer.readInt()));
        Assert.assertEquals((String)"Wrong reserved", (long)message.getReserved(), (long)serializedBuffer.readInt());
    }

    private static Capabilities createCapabilities(int input) {
        Boolean one = (input & 1) > 0;
        Boolean two = (input & 2) > 0;
        Boolean three = (input & 4) > 0;
        Boolean four = (input & 8) > 0;
        Boolean five = (input & 0x20) > 0;
        Boolean six = (input & 0x40) > 0;
        Boolean seven = (input & 0x100) > 0;
        return new Capabilities(one, four, five, seven, three, six, two);
    }
}

