/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetQueueConfigInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetQueueConfigInputBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class GetQueueConfigInputMessageFactoryTest {
    private static final byte GET_QUEUE_CONFIG_INPUT_MESSAGE_CODE_TYPE = 22;
    private static final byte PADDING_IN_QUEUE_CONFIG_INPUT_MESSAGE = 4;
    private SerializerRegistry registry;
    private OFSerializer<GetQueueConfigInput> getQueueFactory;

    @Before
    public void startUp() {
        this.registry = new SerializerRegistryImpl();
        this.registry.init();
        this.getQueueFactory = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(4, GetQueueConfigInput.class));
    }

    @Test
    public void testGetQueueConfigInputMessage() throws Exception {
        GetQueueConfigInputBuilder builder = new GetQueueConfigInputBuilder();
        BufferHelper.setupHeader(builder, 4);
        builder.setPort(new PortNumber(Long.valueOf(66051L)));
        GetQueueConfigInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.getQueueFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV13(out, (byte)22, 16);
        Assert.assertEquals((String)"Wrong port", (long)66051L, (long)out.readUnsignedInt());
        out.skipBytes(4);
    }
}

