/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.BufferHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetAsyncInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetAsyncInputBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class GetaAsyncRequestMessageFactoryTest {
    private static final byte MESSAGE_TYPE = 26;
    private static final int MESSAGE_LENGTH = 8;
    private SerializerRegistry registry;
    private OFSerializer<GetAsyncInput> getAsyncFactory;

    @Before
    public void startUp() {
        this.registry = new SerializerRegistryImpl();
        this.registry.init();
        this.getAsyncFactory = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(4, GetAsyncInput.class));
    }

    @Test
    public void testGetAsyncReques() throws Exception {
        GetAsyncInputBuilder builder = new GetAsyncInputBuilder();
        BufferHelper.setupHeader(builder, 4);
        GetAsyncInput message = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.getAsyncFactory.serialize((DataContainer)message, out);
        BufferHelper.checkHeaderV13(out, (byte)26, 8);
    }
}

